/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics;

import com.dremio.jdbc.shaded.com.codahale.metrics.MetricRegistry;
import com.dremio.jdbc.shaded.com.dremio.common.DeferredException;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.config.MetricsConfigurator;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class ReporterManager {
    private static final Logger logger = LoggerFactory.getLogger(ReporterManager.class);
    private volatile Set<MetricsConfigurator> configurators = Collections.emptySet();
    private final MetricRegistry registry;

    public ReporterManager(MetricRegistry registry) {
        this.registry = registry;
    }

    public synchronized void onChange(Collection<MetricsConfigurator> newConfs) {
        try {
            HashSet<MetricsConfigurator> current = new HashSet<MetricsConfigurator>(this.configurators);
            HashSet<MetricsConfigurator> toStart = new HashSet<MetricsConfigurator>();
            HashSet<MetricsConfigurator> totalSet = new HashSet<MetricsConfigurator>();
            for (MetricsConfigurator c : newConfs) {
                if (current.remove(c)) {
                    totalSet.add(c);
                    continue;
                }
                toStart.add(c);
                totalSet.add(c);
            }
            for (MetricsConfigurator c : toStart) {
                try {
                    c.start(this.registry);
                }
                catch (Exception ex) {
                    logger.error("Failure while starting configuration {} metric reporter.", (Object)c.getName(), (Object)ex);
                    totalSet.remove(c);
                }
            }
            DeferredException deferred = new DeferredException();
            for (MetricsConfigurator c : current) {
                deferred.suppressingClose(c);
            }
            if (deferred.getException() != null) {
                logger.warn("Failure while closing one or more metric configurations.", deferred.getException());
            }
            if (toStart.size() > 0 || current.size() > 0) {
                logger.info("Found {} new metric configurations. Found {} no longer valid metric configurations and closed.", (Object)toStart.size(), (Object)current.size());
            }
            this.configurators = totalSet;
        }
        catch (Exception ex) {
            logger.error("Metrics reporter refresh failed.", ex);
        }
    }

    @VisibleForTesting
    Collection<MetricsConfigurator> getParentConfigurators() {
        return Collections.unmodifiableCollection(this.configurators);
    }
}

