/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics;

import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.CommonTags;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.MeterProviders;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tag;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tags;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.function.Supplier;

public final class TimerUtils {
    public static Timer.ResourceSample timed(String name, String description, String ... tags) {
        return MeterProviders.newTimerResourceSample(name, description == null ? "" : description, Tags.of(tags));
    }

    public static Timer.ResourceSample timed(String name, String description, Iterable<Tag> tags) {
        return MeterProviders.newTimerResourceSample(name, description == null ? "" : description, Tags.of(tags));
    }

    public static Timer.ResourceSample timedHistogram(String name, String description, Duration minMs, String ... tags) {
        return (Timer.ResourceSample)((Timer.ResourceSample)TimerUtils.timed(name, description, tags).publishPercentileHistogram()).minimumExpectedValue(minMs);
    }

    public static Timer.ResourceSample timedHistogram(String name, String description, Iterable<Tag> tags) {
        return (Timer.ResourceSample)TimerUtils.timed(name, description, tags).publishPercentileHistogram();
    }

    public static Timer.ResourceSample timedHistogram(String name, String description, String ... tags) {
        return (Timer.ResourceSample)TimerUtils.timed(name, description, tags).publishPercentileHistogram();
    }

    public static <V> V timedOperation(Timer.ResourceSample sample, Supplier<V> operation) {
        try {
            V ret = operation.get();
            sample.tags(Tags.of(CommonTags.TAG_OUTCOME_SUCCESS, CommonTags.TAG_EXCEPTION_NONE));
            V v = ret;
            return v;
        }
        catch (Exception ex) {
            sample.tags(Tags.of(CommonTags.TAG_OUTCOME_ERROR, Tag.of("exception", ex.getClass().getSimpleName())));
            throw ex;
        }
        finally {
            sample.close();
        }
    }

    public static <V, E extends Exception> V timedExceptionThrowingOperation(Timer.ResourceSample sample, ExceptionThrowingCallable<V, E> operation) throws E {
        try {
            V ret = operation.call();
            sample.tags(Tags.of(CommonTags.TAG_OUTCOME_SUCCESS, CommonTags.TAG_EXCEPTION_NONE));
            V v = ret;
            return v;
        }
        catch (Exception ex) {
            sample.tags(Tags.of(CommonTags.TAG_OUTCOME_ERROR, Tag.of("exception", ex.getClass().getSimpleName())));
            throw ex;
        }
        finally {
            sample.close();
        }
    }

    public static void timedOperation(Timer.ResourceSample sample, Runnable operation) {
        try {
            try {
                operation.run();
                sample.tags(Tags.of(CommonTags.TAG_OUTCOME_SUCCESS, CommonTags.TAG_EXCEPTION_NONE));
            }
            catch (Exception ex) {
                sample.tags(Tags.of(CommonTags.TAG_OUTCOME_ERROR, Tag.of("exception", ex.getClass().getSimpleName())));
                throw ex;
            }
        }
        finally {
            sample.close();
        }
    }

    private TimerUtils() {
    }

    @FunctionalInterface
    public static interface ExceptionThrowingCallable<V, E extends Exception> {
        public V call() throws E;
    }
}

