/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics;

import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.CounterWithOutcome;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.SimpleCounter;
import com.dremio.jdbc.shaded.com.google.common.base.Joiner;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tag;

public final class TotalAndOutcomeCounters {
    private final SimpleCounter totalCounter;
    private final CounterWithOutcome outcomeCounter;

    public static TotalAndOutcomeCounters of(String name) {
        return new TotalAndOutcomeCounters(SimpleCounter.of(name), CounterWithOutcome.of(TotalAndOutcomeCounters.getNameForOutcomeCounter(name)));
    }

    public static TotalAndOutcomeCounters of(String name, Iterable<Tag> tags) {
        return new TotalAndOutcomeCounters(SimpleCounter.of(name, tags), CounterWithOutcome.of(TotalAndOutcomeCounters.getNameForOutcomeCounter(name), tags));
    }

    public static TotalAndOutcomeCounters of(String name, String description) {
        return new TotalAndOutcomeCounters(SimpleCounter.of(name, description), CounterWithOutcome.of(TotalAndOutcomeCounters.getNameForOutcomeCounter(name), description));
    }

    public static TotalAndOutcomeCounters of(String name, String description, Iterable<Tag> tags) {
        return new TotalAndOutcomeCounters(SimpleCounter.of(name, description, tags), CounterWithOutcome.of(TotalAndOutcomeCounters.getNameForOutcomeCounter(name), description, tags));
    }

    private TotalAndOutcomeCounters(SimpleCounter totalCounter, CounterWithOutcome outcomeCounter) {
        this.totalCounter = totalCounter;
        this.outcomeCounter = outcomeCounter;
    }

    public void incrementTotal() {
        this.totalCounter.increment();
    }

    public long countTotal() {
        return this.totalCounter.count();
    }

    public void succeeded() {
        this.outcomeCounter.succeeded();
    }

    public long countSucceeded() {
        return this.outcomeCounter.countSucceeded();
    }

    public void errored() {
        this.outcomeCounter.errored();
    }

    public long countErrored() {
        return this.outcomeCounter.countErrored();
    }

    public void userErrored() {
        this.outcomeCounter.userErrored();
    }

    public long countUserErrored() {
        return this.outcomeCounter.countUserErrored();
    }

    private static String getNameForOutcomeCounter(String name) {
        return Joiner.on('.').join(name, "outcome", new Object[0]);
    }
}

