/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics;

import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.CommonTags;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.metrics.MeterProviders;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Meter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tag;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tags;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;

public final class UpdatableTimer {
    private final Meter.MeterProvider<Timer> timer;

    public static UpdatableTimer of(String name) {
        return new UpdatableTimer(MeterProviders.newTimerProvider(name));
    }

    public static UpdatableTimer of(String name, String description) {
        return new UpdatableTimer(MeterProviders.newTimerProvider(name, description));
    }

    private UpdatableTimer(Meter.MeterProvider<Timer> timer) {
        this.timer = timer;
    }

    public void updateOnSuccess(long duration, TimeUnit timeUnit) {
        this.timer.withTags(Tags.of(CommonTags.TAG_OUTCOME_SUCCESS, CommonTags.TAG_EXCEPTION_NONE)).record(duration, timeUnit);
    }

    public void updateOnError(long duration, TimeUnit timeUnit) {
        this.timer.withTags(Tags.of(CommonTags.TAG_OUTCOME_ERROR, CommonTags.TAG_EXCEPTION_NONE)).record(duration, timeUnit);
    }

    public void updateOnError(long duration, TimeUnit timeUnit, Throwable ex) {
        this.updateOnError(duration, timeUnit, ex.getClass());
    }

    public void updateOnError(long duration, TimeUnit timeUnit, Class<? extends Throwable> exClass) {
        this.timer.withTags(Tags.of(CommonTags.TAG_OUTCOME_ERROR, Tag.of("exception", exClass.getSimpleName()))).record(duration, timeUnit);
    }
}

