/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.telemetry.api.tracing.http;

import com.dremio.jdbc.shaded.com.dremio.common.logging.StructuredLogger;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.Telemetry;
import com.dremio.jdbc.shaded.com.dremio.telemetry.api.log.RequestTracingLogProtobuf;
import com.dremio.jdbc.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import com.dremio.jdbc.shaded.io.opentelemetry.api.trace.Span;
import com.dremio.jdbc.shaded.io.opentelemetry.api.trace.SpanBuilder;
import com.dremio.jdbc.shaded.io.opentelemetry.api.trace.SpanKind;
import com.dremio.jdbc.shaded.io.opentelemetry.api.trace.Tracer;
import com.dremio.jdbc.shaded.io.opentelemetry.context.Scope;
import com.dremio.jdbc.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import com.dremio.jdbc.shaded.io.opentelemetry.semconv.SemanticAttributes;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.StringUtils;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;

@Priority(value=3000)
public class ServerTracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(ServerTracingFilter.class);
    private static Tracer tracer;
    public static final String TRACING_SCOPE_CONTEXT_PROPERTY = "tracing-scope";
    public static final String TRACING_SPAN_CONTEXT_PROPERTY = "tracing-span";
    public static final String REQUEST_ID_CONTEXT_PROPERTY = "request_id";
    public static final String REQUEST_ID_HEADER = "X-Request-ID";
    public static final String REQUEST_TRACING_LOGGER = "tracing.logger";
    private static final StructuredLogger structuredLogger;
    @Context
    private ResourceInfo resourceInfo;
    private final boolean checkForParentContextEnabled;
    private final String forcedSamplingHeader;

    public ServerTracingFilter() {
        this(false);
    }

    public ServerTracingFilter(boolean checkForParentSpansEnabled) {
        this(checkForParentSpansEnabled, null);
    }

    public ServerTracingFilter(boolean checkForParentSpansEnabled, String forceSamplingHeader) {
        this.checkForParentContextEnabled = checkForParentSpansEnabled;
        this.forcedSamplingHeader = forceSamplingHeader;
    }

    public boolean isCheckForParentContextEnabled() {
        return this.checkForParentContextEnabled;
    }

    private static Tracer getTracer() {
        if (tracer == null) {
            tracer = GlobalOpenTelemetry.getTracer("com.dremio.jdbc.shaded.com.dremio.server.http");
        }
        return tracer;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Object spanName = this.resourceInfo != null ? this.resourceInfo.getResourceClass().getName() + "." + this.resourceInfo.getResourceMethod().getName() : "http-request";
        SpanBuilder spanBuilder = ServerTracingFilter.getTracer().spanBuilder(requestContext.getMethod() + " " + (String)spanName);
        spanBuilder.setSpanKind(SpanKind.SERVER);
        spanBuilder.setAttribute(SemanticAttributes.HTTP_METHOD, requestContext.getMethod());
        spanBuilder.setAttribute(SemanticAttributes.HTTP_URL, requestContext.getUriInfo().getRequestUri().toASCIIString());
        MultivaluedMap pathParams = requestContext.getUriInfo().getPathParameters();
        if (!pathParams.isEmpty()) {
            pathParams.forEach((key, value) -> spanBuilder.setAttribute((String)key, String.join((CharSequence)",", value)));
        }
        if (this.forcedSamplingHeader != null && requestContext.getHeaders().containsKey((Object)this.forcedSamplingHeader)) {
            logger.debug("Found Header in request - '{}' : '{}'", (Object)this.forcedSamplingHeader, requestContext.getHeaders().getFirst((Object)this.forcedSamplingHeader));
            boolean headerValue = Boolean.parseBoolean((String)requestContext.getHeaders().getFirst((Object)this.forcedSamplingHeader));
            if (headerValue) {
                spanBuilder.setAttribute(Telemetry.FORCE_SAMPLING_ATTRIBUTE, Boolean.valueOf(true));
            }
        }
        if (this.isCheckForParentContextEnabled()) {
            com.dremio.jdbc.shaded.io.opentelemetry.context.Context parentContext = this.extractParentContext(requestContext);
            spanBuilder.setParent(parentContext);
        }
        Span span = spanBuilder.startSpan();
        requestContext.setProperty(TRACING_SPAN_CONTEXT_PROPERTY, (Object)span);
        requestContext.setProperty(TRACING_SCOPE_CONTEXT_PROPERTY, (Object)span.makeCurrent());
        if (this.shouldHandleRequestId(span)) {
            String requestId = this.getOrCreateRequestId(requestContext);
            requestContext.setProperty(REQUEST_ID_CONTEXT_PROPERTY, (Object)requestId);
            this.logRequestTraceInfo(requestId, span);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        int responseStatus = responseContext.getStatus();
        Scope scope = (Scope)requestContext.getProperty(TRACING_SCOPE_CONTEXT_PROPERTY);
        Span span = (Span)requestContext.getProperty(TRACING_SPAN_CONTEXT_PROPERTY);
        if (scope != null) {
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, responseStatus);
            span.end();
            scope.close();
        }
        if (this.shouldHandleRequestId(span)) {
            String requestId = (String)requestContext.getProperty(REQUEST_ID_CONTEXT_PROPERTY);
            this.attachRequestIdToResponseIfNotExists(responseContext, requestId);
        }
    }

    private com.dremio.jdbc.shaded.io.opentelemetry.context.Context extractParentContext(ContainerRequestContext requestContext) {
        TextMapGetter<ContainerRequestContext> getter = new TextMapGetter<ContainerRequestContext>(){

            @Override
            public Iterable<String> keys(ContainerRequestContext carrier) {
                return carrier.getHeaders().keySet();
            }

            @Override
            @Nullable
            public String get(@Nullable ContainerRequestContext carrier, @Nonnull String key) {
                if (carrier != null) {
                    return carrier.getHeaderString(key);
                }
                return null;
            }
        };
        return GlobalOpenTelemetry.get().getPropagators().getTextMapPropagator().extract(com.dremio.jdbc.shaded.io.opentelemetry.context.Context.current(), requestContext, getter);
    }

    private void attachRequestIdToResponseIfNotExists(ContainerResponseContext responseContext, String requestId) {
        if (StringUtils.isBlank(responseContext.getHeaderString(REQUEST_ID_HEADER))) {
            responseContext.getHeaders().add((Object)REQUEST_ID_HEADER, (Object)requestId);
        }
    }

    private void logRequestTraceInfo(String requestId, Span span) {
        String traceId = span.getSpanContext().getTraceId();
        String spanId = span.getSpanContext().getSpanId();
        structuredLogger.info(RequestTracingLogProtobuf.RequestTracingLog.newBuilder().setRequestId(requestId).setTraceId(traceId).setSpanId(spanId).build(), "Using request id [{}]; trace id [{}]; span id [{}] for the request.", requestId, traceId, traceId);
    }

    private boolean shouldHandleRequestId(Span span) {
        return span != null && span.getSpanContext().isSampled();
    }

    private String getOrCreateRequestId(ContainerRequestContext requestContext) {
        String requestId = requestContext.getHeaderString(REQUEST_ID_HEADER);
        if (StringUtils.isNotBlank(requestId)) {
            return requestId;
        }
        String newRequestId = UUID.randomUUID().toString();
        logger.debug("Request ID header is missing on the request. Generating new on instead: {}", (Object)newRequestId);
        return newRequestId;
    }

    static {
        structuredLogger = StructuredLogger.get(RequestTracingLogProtobuf.RequestTracingLog.class, ServerTracingFilter.class.getName());
    }
}

