/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.xml;

import com.dremio.jdbc.shaded.com.dremio.common.SuppressForbidden;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import com.dremio.jdbc.shaded.org.xml.sax.SAXException;
import com.dremio.jdbc.shaded.org.xml.sax.SAXNotRecognizedException;
import com.dremio.jdbc.shaded.org.xml.sax.SAXNotSupportedException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public final class SafeXMLFactories {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeXMLFactories.class);

    private SafeXMLFactories() {
    }

    @SuppressForbidden
    public static SAXParserFactory newSafeSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setXIncludeAware(false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException | IllegalArgumentException | ParserConfigurationException e) {
            LOGGER.warn("XML SAX parser factory does not support disabling DTD/External Entities support which might cause some security issue", e);
            return factory;
        }
        return new SafeSAXParserFactory(factory);
    }

    @SuppressForbidden
    public static DocumentBuilderFactory newSafeDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
        }
        catch (IllegalArgumentException | ParserConfigurationException e) {
            LOGGER.warn("XML DOM parser factory does not support disabling DTD/External Entities support which might cause some security issue", e);
        }
        return factory;
    }

    @SuppressForbidden
    public static TransformerFactory newSafeTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException | TransformerConfigurationException e) {
            LOGGER.warn("XML Transformer factory does not support disabling DTD/External Entities support which might cause some security issue", e);
        }
        return factory;
    }

    @SuppressForbidden
    public static XMLInputFactory newSafeXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        try {
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("XML StaX parser factory does not support disabling DTD/External Entities support which might cause some security issue", e);
        }
        return factory;
    }

    private static final class SafeSAXParserFactory
    extends SAXParserFactory {
        private final SAXParserFactory factory;

        private SafeSAXParserFactory(SAXParserFactory factory) {
            this.factory = factory;
        }

        @Override
        public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
            this.factory.setFeature(name, value);
        }

        @Override
        public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
            return this.factory.getFeature(name);
        }

        @Override
        public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
            SAXParser parser = this.factory.newSAXParser();
            try {
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException | IllegalArgumentException e) {
                LOGGER.warn("XML DOM parser does not support disabling DTD/External Entities support which might cause some security issue", e);
            }
            return parser;
        }
    }
}

