/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.github.rollingmetrics.counter;

import com.dremio.jdbc.shaded.com.github.rollingmetrics.counter.WindowCounter;
import com.dremio.jdbc.shaded.com.github.rollingmetrics.util.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;

public class ResetPeriodicallyCounter
implements WindowCounter {
    private final AtomicLong value = new AtomicLong();
    private final long resetIntervalMillis;
    private final Clock clock;
    private final AtomicLong nextResetTimeMillisRef;

    public ResetPeriodicallyCounter(Duration resetInterval) {
        this(resetInterval, Clock.defaultClock());
    }

    public ResetPeriodicallyCounter(Duration resetInterval, Clock clock) {
        if (resetInterval.isNegative() || resetInterval.isZero()) {
            throw new IllegalArgumentException("intervalBetweenChunkResetting must be a positive duration");
        }
        this.resetIntervalMillis = resetInterval.toMillis();
        this.clock = clock;
        this.nextResetTimeMillisRef = new AtomicLong(clock.currentTimeMillis() + this.resetIntervalMillis);
    }

    @Override
    public void add(long delta) {
        long currentValue;
        long currentTimeMillis;
        long nextResetTimeMillis;
        do {
            nextResetTimeMillis = this.nextResetTimeMillisRef.get();
            currentTimeMillis = this.clock.currentTimeMillis();
            if (currentTimeMillis < nextResetTimeMillis) {
                this.value.addAndGet(delta);
                return;
            }
            currentValue = this.value.get();
        } while (!this.nextResetTimeMillisRef.compareAndSet(nextResetTimeMillis, Long.MAX_VALUE));
        this.value.addAndGet(delta - currentValue);
        this.nextResetTimeMillisRef.set(currentTimeMillis + this.resetIntervalMillis);
    }

    @Override
    public long getSum() {
        long currentTimeMillis;
        long currentValue;
        long nextResetTimeMillis;
        do {
            nextResetTimeMillis = this.nextResetTimeMillisRef.get();
            currentValue = this.value.get();
            currentTimeMillis = this.clock.currentTimeMillis();
            if (currentTimeMillis >= nextResetTimeMillis) continue;
            return currentValue;
        } while (!this.nextResetTimeMillisRef.compareAndSet(nextResetTimeMillis, Long.MAX_VALUE));
        this.value.addAndGet(-currentValue);
        this.nextResetTimeMillisRef.set(currentTimeMillis + this.resetIntervalMillis);
        return this.value.get();
    }

    public String toString() {
        return "ResetPeriodicallyCounter{value=" + this.value + ", resetIntervalMillis=" + this.resetIntervalMillis + ", clock=" + this.clock + ", nextResetTimeMillisRef=" + this.nextResetTimeMillisRef + '}';
    }
}

