/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.github.rollingmetrics.hitratio;

import java.util.concurrent.atomic.AtomicLong;

public class HitRatioUtil {
    static double getRatio(long compositeRatio) {
        int hit = HitRatioUtil.getHitFromCompositeRatio(compositeRatio);
        int total = HitRatioUtil.getTotalCountFromCompositeRatio(compositeRatio);
        return (double)hit / (double)total;
    }

    static long updateRatio(AtomicLong compositeRatioRef, int hitCount, int totalCount) {
        long accumulatedTotal;
        long accumulatedHit;
        long newCompositeRatio;
        long compositeRatio;
        if (hitCount > totalCount) {
            throw new IllegalArgumentException("hitCount should be <= totalCount");
        }
        if (totalCount < 1) {
            throw new IllegalArgumentException("totalCount should be >= 1");
        }
        if (hitCount < 0) {
            throw new IllegalArgumentException("hitCount should be >= 0");
        }
        do {
            compositeRatio = compositeRatioRef.get();
            accumulatedHit = HitRatioUtil.getHitFromCompositeRatio(compositeRatio);
            accumulatedHit += (long)hitCount;
            accumulatedTotal = HitRatioUtil.getTotalCountFromCompositeRatio(compositeRatio);
            if ((accumulatedTotal += (long)totalCount) <= Integer.MAX_VALUE) continue;
            accumulatedHit /= 2L;
            accumulatedTotal /= 2L;
        } while (!compositeRatioRef.compareAndSet(compositeRatio, newCompositeRatio = HitRatioUtil.toLong((int)accumulatedHit, (int)accumulatedTotal)));
        return newCompositeRatio;
    }

    static int getHitFromCompositeRatio(long compositeRatio) {
        return (int)(compositeRatio >> 32);
    }

    static int getTotalCountFromCompositeRatio(long compositeRatio) {
        return (int)compositeRatio;
    }

    static long toLong(int first, int second) {
        return (long)first << 32 | (long)second & 0xFFFFFFFFL;
    }
}

