/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.github.rollingmetrics.top.impl.collector;

import com.dremio.jdbc.shaded.com.github.rollingmetrics.top.Position;
import com.dremio.jdbc.shaded.com.github.rollingmetrics.top.impl.collector.PositionCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

class MultiPositionCollector
implements PositionCollector {
    private final TreeSet<Position> positions = new TreeSet();
    private final int maxSize;

    MultiPositionCollector(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(Position position) {
        if (this.positions.size() < this.maxSize) {
            this.positions.add(position);
            return true;
        }
        Position min2 = this.positions.first();
        if (PositionCollector.isNeedToAdd(position, min2)) {
            if (this.positions.add(position)) {
                this.positions.remove(min2);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void addInto(PositionCollector other) {
        for (Position position : this.positions.descendingSet()) {
            if (other.add(position)) continue;
            return;
        }
    }

    @Override
    public void reset() {
        this.positions.clear();
    }

    @Override
    public List<Position> getPositionsInDescendingOrder() {
        if (this.positions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Position> result = new ArrayList<Position>(this.positions.size());
        result.addAll(this.positions.descendingSet());
        return result;
    }

    public String toString() {
        return "MultiPositionCollector{positions=" + this.positions + ", maxSize=" + this.maxSize + '}';
    }
}

