/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.github.rollingmetrics.top.impl.recorder;

import com.dremio.jdbc.shaded.com.github.rollingmetrics.top.Position;
import com.dremio.jdbc.shaded.com.github.rollingmetrics.top.impl.collector.PositionCollector;
import com.dremio.jdbc.shaded.com.github.rollingmetrics.top.impl.recorder.PositionRecorder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class SinglePositionRecorder
extends PositionRecorder {
    private final AtomicReference<Position> max = new AtomicReference<Object>(null);

    SinglePositionRecorder(long latencyThresholdNanos, int maxDescriptionLength) {
        super(1, latencyThresholdNanos, maxDescriptionLength);
    }

    @Override
    protected void updateConcurrently(long timestamp, long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier, long latencyNanos) {
        Position previousMax;
        Position newMax = null;
        do {
            if (!this.isNeedToAdd(timestamp, latencyNanos, previousMax = this.max.get())) {
                return;
            }
            if (newMax != null) continue;
            newMax = new Position(timestamp, latencyTime, latencyUnit, descriptionSupplier, this.maxDescriptionLength);
        } while (!this.max.compareAndSet(previousMax, newMax));
    }

    @Override
    public List<Position> getPositionsInDescendingOrder() {
        Position position = this.max.get();
        if (position == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(position);
    }

    @Override
    public void reset() {
        this.max.set(null);
    }

    @Override
    public void addInto(PositionCollector collector) {
        Position position = this.max.get();
        if (position != null) {
            collector.add(position);
        }
    }

    public String toString() {
        return "SinglePositionRecorder{max=" + this.max + '}';
    }
}

