/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc;

import com.dremio.jdbc.shaded.io.grpc.ForwardingServerCallListener;
import com.dremio.jdbc.shaded.io.grpc.ServerCall;
import com.dremio.jdbc.shaded.io.grpc.Status;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Counter;
import java.util.function.Consumer;
import java.util.function.Supplier;

class MetricCollectingServerCallListener<Q>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<Q> {
    private final Counter requestCounter;
    private final Supplier<Status.Code> responseCodeSupplier;
    private final Consumer<Status.Code> responseStatusTiming;

    public MetricCollectingServerCallListener(ServerCall.Listener<Q> delegate, Counter requestCounter, Supplier<Status.Code> responseCodeSupplier, Consumer<Status.Code> responseStatusTiming) {
        super(delegate);
        this.requestCounter = requestCounter;
        this.responseCodeSupplier = responseCodeSupplier;
        this.responseStatusTiming = responseStatusTiming;
    }

    public void onMessage(Q requestMessage) {
        this.requestCounter.increment();
        super.onMessage(requestMessage);
    }

    public void onComplete() {
        this.report(this.responseCodeSupplier.get());
        super.onComplete();
    }

    public void onCancel() {
        this.report(Status.Code.CANCELLED);
        super.onCancel();
    }

    private void report(Status.Code code) {
        this.responseStatusTiming.accept(code);
    }
}

