/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc;

import com.dremio.jdbc.shaded.io.grpc.ClientCall;
import com.dremio.jdbc.shaded.io.grpc.ForwardingClientCall;
import com.dremio.jdbc.shaded.io.grpc.Metadata;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.GrpcClientObservationContext;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.ObservationGrpcClientCallListener;
import com.dremio.jdbc.shaded.io.micrometer.observation.Observation;

class ObservationGrpcClientCall<ReqT, RespT>
extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
    private final Observation observation;

    ObservationGrpcClientCall(ClientCall<ReqT, RespT> delegate, Observation observation) {
        super(delegate);
        this.observation = observation;
    }

    public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
        ((GrpcClientObservationContext)this.observation.getContext()).setCarrier(metadata);
        try (Observation.Scope scope = this.observation.start().openScope();){
            super.start(new ObservationGrpcClientCallListener<RespT>(responseListener, this.observation), metadata);
        }
        catch (Throwable ex) {
            this.handleFailure(ex);
            throw ex;
        }
    }

    public void halfClose() {
        try (Observation.Scope scope = this.observation.openScope();){
            super.halfClose();
        }
        catch (Throwable ex) {
            this.handleFailure(ex);
            throw ex;
        }
    }

    public void sendMessage(ReqT message) {
        this.observation.event(GrpcObservationDocumentation.GrpcClientEvents.MESSAGE_SENT);
        try (Observation.Scope scope = this.observation.openScope();){
            super.sendMessage(message);
        }
    }

    private void handleFailure(Throwable ex) {
        this.observation.error(ex).stop();
    }
}

