/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc;

import com.dremio.jdbc.shaded.io.grpc.ForwardingServerCall;
import com.dremio.jdbc.shaded.io.grpc.Metadata;
import com.dremio.jdbc.shaded.io.grpc.ServerCall;
import com.dremio.jdbc.shaded.io.grpc.Status;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import com.dremio.jdbc.shaded.io.micrometer.observation.Observation;

class ObservationGrpcServerCall<ReqT, RespT>
extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
    private final Observation observation;

    ObservationGrpcServerCall(ServerCall<ReqT, RespT> delegate, Observation observation) {
        super(delegate);
        this.observation = observation;
    }

    public void sendMessage(RespT message) {
        this.observation.event(GrpcObservationDocumentation.GrpcServerEvents.MESSAGE_SENT);
        super.sendMessage(message);
    }

    public void close(Status status, Metadata trailers) {
        if (status.getCause() != null) {
            this.observation.error(status.getCause());
        }
        GrpcServerObservationContext context = (GrpcServerObservationContext)this.observation.getContext();
        context.setStatusCode(status.getCode());
        super.close(status, trailers);
    }
}

