/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc;

import com.dremio.jdbc.shaded.io.grpc.Metadata;
import com.dremio.jdbc.shaded.io.grpc.MethodDescriptor;
import com.dremio.jdbc.shaded.io.grpc.ServerCall;
import com.dremio.jdbc.shaded.io.grpc.ServerCallHandler;
import com.dremio.jdbc.shaded.io.grpc.ServerInterceptor;
import com.dremio.jdbc.shaded.io.micrometer.common.lang.Nullable;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.DefaultGrpcServerObservationConvention;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.GrpcServerObservationConvention;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerCall;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerCallListener;
import com.dremio.jdbc.shaded.io.micrometer.observation.Observation;
import com.dremio.jdbc.shaded.io.micrometer.observation.ObservationRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ObservationGrpcServerInterceptor
implements ServerInterceptor {
    private static final GrpcServerObservationConvention DEFAULT_CONVENTION = new DefaultGrpcServerObservationConvention();
    private static final Map<String, Metadata.Key<String>> KEY_CACHE = new ConcurrentHashMap<String, Metadata.Key<String>>();
    private final ObservationRegistry registry;
    @Nullable
    private GrpcServerObservationConvention customConvention;

    public ObservationGrpcServerInterceptor(ObservationRegistry registry) {
        this.registry = registry;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Supplier<GrpcServerObservationContext> contextSupplier = () -> {
            GrpcServerObservationContext context = new GrpcServerObservationContext((carrier, keyName) -> {
                Metadata.Key key = KEY_CACHE.computeIfAbsent(keyName, k -> Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                return (String)carrier.get(key);
            });
            context.setCarrier(headers);
            MethodDescriptor methodDescriptor = call.getMethodDescriptor();
            String serviceName = methodDescriptor.getServiceName();
            String methodName = methodDescriptor.getBareMethodName();
            String fullMethodName = methodDescriptor.getFullMethodName();
            MethodDescriptor.MethodType methodType = methodDescriptor.getType();
            if (serviceName != null) {
                context.setServiceName(serviceName);
            }
            if (methodName != null) {
                context.setMethodName(methodName);
            }
            context.setFullMethodName(fullMethodName);
            context.setMethodType(methodType);
            context.setAuthority(call.getAuthority());
            return context;
        };
        Observation observation = GrpcObservationDocumentation.SERVER.observation(this.customConvention, DEFAULT_CONVENTION, contextSupplier, this.registry).start();
        if (observation.isNoop()) {
            return next.startCall(call, headers);
        }
        ObservationGrpcServerCall<ReqT, RespT> serverCall = new ObservationGrpcServerCall<ReqT, RespT>(call, observation);
        try {
            ServerCall.Listener result = next.startCall(serverCall, headers);
            return new ObservationGrpcServerCallListener(result, observation);
        }
        catch (Exception ex) {
            observation.error(ex).stop();
            throw ex;
        }
    }

    public void setCustomConvention(@Nullable GrpcServerObservationConvention customConvention) {
        this.customConvention = customConvention;
    }
}

