/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.system;

import com.dremio.jdbc.shaded.io.micrometer.common.lang.NonNullApi;
import com.dremio.jdbc.shaded.io.micrometer.common.lang.NonNullFields;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.MeterRegistry;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tag;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Tags;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.binder.MeterBinder;
import java.io.File;
import java.util.Collections;

@NonNullApi
@NonNullFields
public class DiskSpaceMetrics
implements MeterBinder {
    private final Iterable<Tag> tags;
    private final File path;
    private final String absolutePath;

    public DiskSpaceMetrics(File path) {
        this(path, Collections.emptyList());
    }

    public DiskSpaceMetrics(File path, Iterable<Tag> tags) {
        this.path = path;
        this.absolutePath = path.getAbsolutePath();
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Tags tagsWithPath = Tags.concat(this.tags, "path", this.absolutePath);
        Gauge.builder("disk.free", this.path, File::getUsableSpace).tags(tagsWithPath).description("Usable space for path").baseUnit("bytes").strongReference(true).register(registry);
        Gauge.builder("disk.total", this.path, File::getTotalSpace).tags(tagsWithPath).description("Total space for path").baseUnit("bytes").strongReference(true).register(registry);
    }
}

