/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution;

import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Clock;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.AbstractTimeWindowHistogram;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.dremio.jdbc.shaded.org.HdrHistogram.DoubleHistogram;
import com.dremio.jdbc.shaded.org.HdrHistogram.DoubleRecorder;
import java.io.PrintStream;
import java.util.Iterator;

public class TimeWindowPercentileHistogram
extends AbstractTimeWindowHistogram<DoubleRecorder, DoubleHistogram> {
    private final DoubleHistogram intervalHistogram;

    public TimeWindowPercentileHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean supportsAggregablePercentiles) {
        super(clock, distributionStatisticConfig, DoubleRecorder.class, supportsAggregablePercentiles);
        this.intervalHistogram = new DoubleHistogram(this.percentilePrecision(distributionStatisticConfig));
        this.initRingBuffer();
    }

    @Override
    DoubleRecorder newBucket() {
        return new DoubleRecorder(this.percentilePrecision(this.distributionStatisticConfig));
    }

    @Override
    void recordDouble(DoubleRecorder bucket, double value) {
        bucket.recordValue(value);
    }

    @Override
    void recordLong(DoubleRecorder bucket, long value) {
        bucket.recordValue((double)value);
    }

    @Override
    void resetBucket(DoubleRecorder bucket) {
        bucket.reset();
    }

    DoubleHistogram newAccumulatedHistogram(DoubleRecorder[] ringBuffer) {
        return new DoubleHistogram(this.percentilePrecision(this.distributionStatisticConfig));
    }

    @Override
    void accumulate() {
        ((DoubleRecorder)this.currentHistogram()).getIntervalHistogramInto(this.intervalHistogram);
        ((DoubleHistogram)this.accumulatedHistogram()).add(this.intervalHistogram);
    }

    @Override
    void resetAccumulatedHistogram() {
        ((DoubleHistogram)this.accumulatedHistogram()).reset();
    }

    @Override
    double valueAtPercentile(double percentile) {
        return ((DoubleHistogram)this.accumulatedHistogram()).getValueAtPercentile(percentile);
    }

    @Override
    Iterator<CountAtBucket> countsAtValues(final Iterator<Double> values) {
        return new Iterator<CountAtBucket>(){
            private double cumulativeCount = 0.0;
            private double lowerBoundValue = 0.0;

            @Override
            public boolean hasNext() {
                return values.hasNext();
            }

            @Override
            public CountAtBucket next() {
                double higherBoundValue = (Double)values.next();
                double count = ((DoubleHistogram)TimeWindowPercentileHistogram.this.accumulatedHistogram()).getCountBetweenValues(this.lowerBoundValue, higherBoundValue);
                this.lowerBoundValue = ((DoubleHistogram)TimeWindowPercentileHistogram.this.accumulatedHistogram()).nextNonEquivalentValue(higherBoundValue);
                this.cumulativeCount += count;
                return new CountAtBucket(higherBoundValue, this.cumulativeCount);
            }
        };
    }

    private int percentilePrecision(DistributionStatisticConfig config) {
        return config.getPercentilePrecision() == null ? 1 : config.getPercentilePrecision();
    }

    @Override
    void outputSummary(PrintStream out, double bucketScaling) {
        ((DoubleHistogram)this.accumulatedHistogram()).outputPercentileDistribution(out, Double.valueOf(bucketScaling));
    }
}

