/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard;

import com.dremio.jdbc.shaded.com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.dremio.jdbc.shaded.com.codahale.metrics.MetricRegistry;
import com.dremio.jdbc.shaded.io.micrometer.common.lang.Nullable;
import com.dremio.jdbc.shaded.io.micrometer.common.util.internal.logging.WarnThenDebugLogger;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Clock;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Counter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.DistributionSummary;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.FunctionCounter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.FunctionTimer;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Gauge;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.LongTaskTimer;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Measurement;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Meter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.MeterRegistry;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Statistic;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Timer;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.config.NamingConvention;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.HistogramGauges;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardClock;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardCounter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardDistributionSummary;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardFunctionCounter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardFunctionTimer;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardGauge;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardTimer;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.internal.DefaultMeter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public abstract class DropwizardMeterRegistry
extends MeterRegistry {
    private static final WarnThenDebugLogger logger = new WarnThenDebugLogger(DropwizardMeterRegistry.class);
    private final MetricRegistry registry;
    private final HierarchicalNameMapper nameMapper;
    private final DropwizardClock dropwizardClock;
    private final DropwizardConfig dropwizardConfig;
    private final AtomicBoolean warnLogged = new AtomicBoolean();

    public DropwizardMeterRegistry(DropwizardConfig config, MetricRegistry registry, HierarchicalNameMapper nameMapper, Clock clock) {
        super(clock);
        config.requireValid();
        this.dropwizardConfig = config;
        this.dropwizardClock = new DropwizardClock(clock);
        this.registry = registry;
        this.nameMapper = nameMapper;
        this.config().namingConvention(NamingConvention.camelCase).onMeterRemoved(this::onMeterRemoved);
    }

    private void onMeterRemoved(Meter meter) {
        this.registry.remove(this.hierarchicalName(meter.getId()));
        if (meter instanceof LongTaskTimer) {
            for (Statistic statistic : Statistic.values()) {
                this.registry.remove(this.hierarchicalName(meter.getId().withTag(statistic)));
            }
        }
    }

    public MetricRegistry getDropwizardRegistry() {
        return this.registry;
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        com.dremio.jdbc.shaded.com.codahale.metrics.Meter meter = new com.dremio.jdbc.shaded.com.codahale.metrics.Meter(this.dropwizardClock);
        this.registry.register(this.hierarchicalName(id), meter);
        return new DropwizardCounter(id, meter);
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        WeakReference ref = new WeakReference(obj);
        com.dremio.jdbc.shaded.com.codahale.metrics.Gauge<Double> gauge = () -> {
            Object obj2 = ref.get();
            if (obj2 != null) {
                try {
                    return valueFunction.applyAsDouble(obj2);
                }
                catch (Throwable ex) {
                    logger.log(() -> "Failed to apply the value function for the gauge '" + id.getName() + "'.", ex);
                }
            }
            return this.nullGaugeValue();
        };
        this.registry.register(this.hierarchicalName(id), gauge);
        return new DropwizardGauge(id, gauge);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        DropwizardTimer timer = new DropwizardTimer(id, this.registry.timer(this.hierarchicalName(id), () -> new com.dremio.jdbc.shaded.com.codahale.metrics.Timer(new ExponentiallyDecayingReservoir(), this.dropwizardClock)), this.clock, distributionStatisticConfig, pauseDetector);
        HistogramGauges.registerWithCommonFormat(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        DropwizardDistributionSummary summary = new DropwizardDistributionSummary(id, this.clock, this.registry.histogram(this.hierarchicalName(id)), distributionStatisticConfig, scale);
        HistogramGauges.registerWithCommonFormat(summary, (MeterRegistry)this);
        return summary;
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.ACTIVE_TASKS)), ltt::activeTasks);
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.DURATION)), () -> ltt.duration(TimeUnit.NANOSECONDS));
        this.registry.register(this.hierarchicalName(id.withTag(Statistic.MAX)), () -> ltt.max(TimeUnit.NANOSECONDS));
        HistogramGauges.registerWithCommonFormat(ltt, (MeterRegistry)this);
        return ltt;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        DropwizardFunctionTimer<T> ft = new DropwizardFunctionTimer<T>(id, this.clock, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
        this.registry.register(this.hierarchicalName(id), ft.getDropwizardMeter());
        return ft;
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        DropwizardFunctionCounter<T> fc = new DropwizardFunctionCounter<T>(id, this.clock, obj, countFunction);
        this.registry.register(this.hierarchicalName(id), fc.getDropwizardMeter());
        return fc;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> this.registry.register(this.hierarchicalName(id.withTag(ms.getStatistic())), ms::getValue));
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private String hierarchicalName(Meter.Id id) {
        return this.nameMapper.toHierarchicalName(id, this.config().namingConvention());
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.dropwizardConfig.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    protected abstract Double nullGaugeValue();
}

