/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.jmx;

import com.dremio.jdbc.shaded.com.codahale.metrics.MetricRegistry;
import com.dremio.jdbc.shaded.com.codahale.metrics.jmx.JmxReporter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Clock;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.util.HierarchicalNameMapper;
import com.dremio.jdbc.shaded.io.micrometer.jmx.JmxConfig;

public class JmxMeterRegistry
extends DropwizardMeterRegistry {
    private final JmxReporter reporter;

    public JmxMeterRegistry(JmxConfig config, Clock clock) {
        this(config, clock, HierarchicalNameMapper.DEFAULT);
    }

    public JmxMeterRegistry(JmxConfig config, Clock clock, HierarchicalNameMapper nameMapper) {
        this(config, clock, nameMapper, new MetricRegistry());
    }

    public JmxMeterRegistry(JmxConfig config, Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry) {
        this(config, clock, nameMapper, metricRegistry, JmxMeterRegistry.defaultJmxReporter(config, metricRegistry));
    }

    public JmxMeterRegistry(JmxConfig config, Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry, JmxReporter jmxReporter) {
        super(config, metricRegistry, nameMapper, clock);
        this.reporter = jmxReporter;
        this.reporter.start();
    }

    private static JmxReporter defaultJmxReporter(JmxConfig config, MetricRegistry metricRegistry) {
        return JmxReporter.forRegistry(metricRegistry).inDomain(config.domain()).build();
    }

    public void stop() {
        this.reporter.stop();
    }

    public void start() {
        this.reporter.start();
    }

    @Override
    public void close() {
        this.stop();
        super.close();
    }

    @Override
    protected Double nullGaugeValue() {
        return Double.NaN;
    }
}

