/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.observation.aop;

import com.dremio.jdbc.shaded.io.micrometer.common.KeyValues;
import com.dremio.jdbc.shaded.io.micrometer.common.docs.KeyName;
import com.dremio.jdbc.shaded.io.micrometer.common.lang.Nullable;
import com.dremio.jdbc.shaded.io.micrometer.observation.Observation;
import com.dremio.jdbc.shaded.io.micrometer.observation.ObservationConvention;
import com.dremio.jdbc.shaded.io.micrometer.observation.ObservationRegistry;
import com.dremio.jdbc.shaded.io.micrometer.observation.annotation.Observed;
import com.dremio.jdbc.shaded.io.micrometer.observation.aop.ObservedAspect;
import com.dremio.jdbc.shaded.io.micrometer.observation.docs.ObservationDocumentation;
import com.dremio.jdbc.shaded.org.aspectj.lang.ProceedingJoinPoint;
import com.dremio.jdbc.shaded.org.aspectj.lang.Signature;

enum ObservedAspectObservationDocumentation implements ObservationDocumentation
{
    DEFAULT;


    static Observation of(ProceedingJoinPoint pjp, Observed observed, ObservationRegistry registry, @Nullable ObservationConvention<ObservedAspect.ObservedAspectContext> observationConvention) {
        String name = observed.name().isEmpty() ? "method.observed" : observed.name();
        Signature signature = pjp.getStaticPart().getSignature();
        String contextualName = observed.contextualName().isEmpty() ? signature.getDeclaringType().getSimpleName() + "#" + signature.getName() : observed.contextualName();
        Observation observation = Observation.createNotStarted(name, () -> new ObservedAspect.ObservedAspectContext(pjp), registry).contextualName(contextualName).lowCardinalityKeyValue(ObservedAspectLowCardinalityKeyName.CLASS_NAME.asString(), signature.getDeclaringTypeName()).lowCardinalityKeyValue(ObservedAspectLowCardinalityKeyName.METHOD_NAME.asString(), signature.getName()).lowCardinalityKeyValues(KeyValues.of(observed.lowCardinalityKeyValues()));
        if (observationConvention != null) {
            observation.observationConvention(observationConvention);
        }
        return observation;
    }

    @Override
    public String getName() {
        return "%s";
    }

    @Override
    public String getContextualName() {
        return "%s";
    }

    @Override
    public KeyName[] getLowCardinalityKeyNames() {
        return ObservedAspectLowCardinalityKeyName.values();
    }

    static enum ObservedAspectLowCardinalityKeyName implements KeyName
    {
        CLASS_NAME{

            @Override
            public String asString() {
                return "class";
            }
        }
        ,
        METHOD_NAME{

            @Override
            public String asString() {
                return "method";
            }
        };

    }
}

