/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.micrometer.prometheus;

import com.dremio.jdbc.shaded.io.micrometer.common.lang.NonNull;
import com.dremio.jdbc.shaded.io.micrometer.common.lang.Nullable;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.AbstractTimer;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Clock;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.Meter;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.FixedBoundaryVictoriaMetricsHistogram;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.Histogram;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.TimeWindowMax;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.dremio.jdbc.shaded.io.micrometer.core.instrument.util.TimeUtils;
import com.dremio.jdbc.shaded.io.micrometer.prometheus.HistogramFlavor;
import com.dremio.jdbc.shaded.io.micrometer.prometheus.PrometheusHistogram;
import com.dremio.jdbc.shaded.io.prometheus.client.exemplars.CounterExemplarSampler;
import com.dremio.jdbc.shaded.io.prometheus.client.exemplars.Exemplar;
import com.dremio.jdbc.shaded.io.prometheus.client.exemplars.ExemplarSampler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusTimer
extends AbstractTimer {
    private static final CountAtBucket[] EMPTY_HISTOGRAM = new CountAtBucket[0];
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final TimeWindowMax max;
    private final HistogramFlavor histogramFlavor;
    @Nullable
    private final Histogram histogram;
    @Nullable
    private final ExemplarSampler exemplarSampler;
    @Nullable
    private final AtomicReference<Exemplar> lastExemplar;
    private boolean histogramExemplarsEnabled = false;

    PrometheusTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, HistogramFlavor histogramFlavor, @Nullable ExemplarSampler exemplarSampler) {
        super(id, clock, DistributionStatisticConfig.builder().percentilesHistogram(false).serviceLevelObjectives(new double[0]).build().merge(distributionStatisticConfig), pauseDetector, TimeUnit.SECONDS, false);
        this.histogramFlavor = histogramFlavor;
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        if (distributionStatisticConfig.isPublishingHistogram()) {
            switch (histogramFlavor) {
                case Prometheus: {
                    PrometheusHistogram prometheusHistogram = new PrometheusHistogram(clock, distributionStatisticConfig, exemplarSampler);
                    this.histogram = prometheusHistogram;
                    this.histogramExemplarsEnabled = prometheusHistogram.isExemplarsEnabled();
                    break;
                }
                case VictoriaMetrics: {
                    this.histogram = new FixedBoundaryVictoriaMetricsHistogram();
                    break;
                }
                default: {
                    this.histogram = null;
                    break;
                }
            }
        } else {
            this.histogram = null;
        }
        if (!this.histogramExemplarsEnabled && exemplarSampler != null) {
            this.exemplarSampler = exemplarSampler;
            this.lastExemplar = new AtomicReference();
        } else {
            this.exemplarSampler = null;
            this.lastExemplar = null;
        }
    }

    @Override
    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
        this.totalTime.add(nanoAmount);
        this.max.record(nanoAmount, TimeUnit.NANOSECONDS);
        if (this.histogram != null) {
            this.histogram.recordLong(nanoAmount);
        }
        if (!this.histogramExemplarsEnabled && this.exemplarSampler != null) {
            this.updateLastExemplar(TimeUtils.nanosToUnit(amount, this.baseTimeUnit()), this.exemplarSampler);
        }
    }

    private void updateLastExemplar(double amount, @NonNull CounterExemplarSampler exemplarSampler) {
        Exemplar prev;
        Exemplar next;
        while ((next = exemplarSampler.sample(amount, prev = this.lastExemplar.get())) != null && next != prev && !this.lastExemplar.compareAndSet(prev, next)) {
        }
    }

    @Nullable
    Exemplar[] histogramExemplars() {
        if (this.histogramExemplarsEnabled) {
            return ((PrometheusHistogram)this.histogram).exemplars();
        }
        return null;
    }

    @Nullable
    Exemplar lastExemplar() {
        if (this.histogramExemplarsEnabled) {
            return ((PrometheusHistogram)this.histogram).lastExemplar();
        }
        return this.lastExemplar != null ? this.lastExemplar.get() : null;
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit(this.totalTime.doubleValue(), unit);
    }

    @Override
    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public HistogramFlavor histogramFlavor() {
        return this.histogramFlavor;
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogram == null ? EMPTY_HISTOGRAM : this.histogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        if (this.histogram == null) {
            return snapshot;
        }
        return new HistogramSnapshot(snapshot.count(), snapshot.total(), snapshot.max(), snapshot.percentileValues(), this.histogramCounts(), snapshot::outputSummary);
    }
}

