/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.netty.buffer;

import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.MutableWrappedByteBuf;
import com.dremio.jdbc.shaded.io.netty.buffer.NettyArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;

public class ExpandableByteBuf
extends MutableWrappedByteBuf {
    private final BufferAllocator allocator;

    public ExpandableByteBuf(ByteBuf buffer, BufferAllocator allocator) {
        super(buffer);
        this.allocator = allocator;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        return new ExpandableByteBuf(this.buffer.copy(index, length), this.allocator);
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        if (newCapacity > this.capacity()) {
            NettyArrowBuf newBuf = NettyArrowBuf.unwrapBuffer(this.allocator.buffer(newCapacity));
            ((ByteBuf)newBuf).writeBytes(this.buffer, 0, this.buffer.capacity());
            ((ByteBuf)newBuf).readerIndex(this.buffer.readerIndex());
            ((ByteBuf)newBuf).writerIndex(this.buffer.writerIndex());
            this.buffer.release();
            this.buffer = newBuf;
            return newBuf;
        }
        return super.capacity(newCapacity);
    }
}

