/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.netty.handler.codec.socks;

import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socks.SocksAuthScheme;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socks.SocksRequest;
import com.dremio.jdbc.shaded.io.netty.handler.codec.socks.SocksRequestType;
import com.dremio.jdbc.shaded.io.netty.util.internal.ObjectUtil;
import java.util.Collections;
import java.util.List;

public final class SocksInitRequest
extends SocksRequest {
    private final List<SocksAuthScheme> authSchemes;

    public SocksInitRequest(List<SocksAuthScheme> authSchemes) {
        super(SocksRequestType.INIT);
        this.authSchemes = ObjectUtil.checkNotNull(authSchemes, "authSchemes");
    }

    public List<SocksAuthScheme> authSchemes() {
        return Collections.unmodifiableList(this.authSchemes);
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.protocolVersion().byteValue());
        byteBuf.writeByte(this.authSchemes.size());
        for (SocksAuthScheme authScheme : this.authSchemes) {
            byteBuf.writeByte(authScheme.byteValue());
        }
    }
}

