/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.netty.handler.ssl.util;

import com.dremio.jdbc.shaded.io.netty.handler.ssl.util.BouncyCastleUtil;
import com.dremio.jdbc.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import com.dremio.jdbc.shaded.org.bouncycastle.asn1.x500.X500Name;
import com.dremio.jdbc.shaded.org.bouncycastle.cert.X509CertificateHolder;
import com.dremio.jdbc.shaded.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.dremio.jdbc.shaded.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import com.dremio.jdbc.shaded.org.bouncycastle.operator.ContentSigner;
import com.dremio.jdbc.shaded.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;

final class BouncyCastleSelfSignedCertGenerator {
    static String[] generate(String fqdn, KeyPair keypair, SecureRandom random, Date notBefore, Date notAfter, String algorithm) throws Exception {
        PrivateKey key = keypair.getPrivate();
        X500Name owner = new X500Name("CN=" + fqdn);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, random), notBefore, notAfter, owner, keypair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder(algorithm.equalsIgnoreCase("EC") ? "SHA256withECDSA" : "SHA256WithRSAEncryption").build(key);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(BouncyCastleUtil.getBcProviderJce()).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        return SelfSignedCertificate.newSelfSignedCertificate(fqdn, key, cert);
    }

    private BouncyCastleSelfSignedCertGenerator() {
    }
}

