/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.opentelemetry.api.internal;

import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public final class ConfigUtil {
    private ConfigUtil() {
    }

    public static String getString(String key, String defaultValue) {
        String normalizedKey = ConfigUtil.normalizePropertyKey(key);
        String systemProperty = System.getProperties().entrySet().stream().filter(entry -> normalizedKey.equals(ConfigUtil.normalizePropertyKey(entry.getKey().toString()))).map(entry -> entry.getValue().toString()).findFirst().orElse(null);
        if (systemProperty != null) {
            return systemProperty;
        }
        return System.getenv().entrySet().stream().filter(entry -> normalizedKey.equals(ConfigUtil.normalizeEnvironmentVariableKey((String)entry.getKey()))).map(Map.Entry::getValue).findFirst().orElse(defaultValue);
    }

    public static String normalizeEnvironmentVariableKey(String key) {
        return key.toLowerCase(Locale.ROOT).replace("_", ".");
    }

    public static String normalizePropertyKey(String key) {
        return key.toLowerCase(Locale.ROOT).replace("-", ".");
    }

    public static <T> T defaultIfNull(@Nullable T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }
}

