/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.prometheus.client;

import com.dremio.jdbc.shaded.io.prometheus.client.CollectorRegistry;
import com.dremio.jdbc.shaded.io.prometheus.client.Predicate;
import com.dremio.jdbc.shaded.io.prometheus.client.exemplars.Exemplar;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class Collector {
    public static final double NANOSECONDS_PER_SECOND = 1.0E9;
    public static final double MILLISECONDS_PER_SECOND = 1000.0;
    private static final Pattern METRIC_NAME_RE = Pattern.compile("[a-zA-Z_:][a-zA-Z0-9_:]*");
    private static final Pattern METRIC_LABEL_NAME_RE = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private static final Pattern RESERVED_METRIC_LABEL_NAME_RE = Pattern.compile("__.*");

    public abstract List<MetricFamilySamples> collect();

    public List<MetricFamilySamples> collect(Predicate<String> sampleNameFilter) {
        List<MetricFamilySamples> all = this.collect();
        if (sampleNameFilter == null) {
            return all;
        }
        ArrayList<MetricFamilySamples> remaining = new ArrayList<MetricFamilySamples>(all.size());
        block0: for (MetricFamilySamples mfs : all) {
            for (String name : mfs.getNames()) {
                if (!sampleNameFilter.test(name)) continue;
                remaining.add(mfs);
                continue block0;
            }
        }
        return remaining;
    }

    public <T extends Collector> T register() {
        return this.register(CollectorRegistry.defaultRegistry);
    }

    public <T extends Collector> T register(CollectorRegistry registry) {
        registry.register(this);
        return (T)this;
    }

    protected static void checkMetricName(String name) {
        if (!METRIC_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric name: " + name);
        }
    }

    public static String sanitizeMetricName(String metricName) {
        int length = metricName.length();
        char[] sanitized = new char[length];
        for (int i = 0; i < length; ++i) {
            int ch = metricName.charAt(i);
            sanitized[i] = ch == 58 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || i > 0 && ch >= 48 && ch <= 57 ? ch : 95;
        }
        return new String(sanitized);
    }

    protected static void checkMetricLabelName(String name) {
        if (!METRIC_LABEL_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric label name: " + name);
        }
        if (RESERVED_METRIC_LABEL_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric label name, reserved for internal use: " + name);
        }
    }

    public static String doubleToGoString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        return Double.toString(d);
    }

    public static interface Describable {
        public List<MetricFamilySamples> describe();
    }

    public static class MetricFamilySamples {
        public final String name;
        public final String unit;
        public final Type type;
        public final String help;
        public final List<Sample> samples;

        public MetricFamilySamples(String name, Type type, String help, List<Sample> samples) {
            this(name, "", type, help, samples);
        }

        public MetricFamilySamples(String name, String unit, Type type, String help, List<Sample> samples) {
            if (!unit.isEmpty() && !name.endsWith("_" + unit)) {
                throw new IllegalArgumentException("Metric's unit is not the suffix of the metric name: " + name);
            }
            if (!(type != Type.INFO && type != Type.STATE_SET || unit.isEmpty())) {
                throw new IllegalArgumentException("Metric is of a type that cannot have a unit: " + name);
            }
            List<Sample> mungedSamples = samples;
            if (type == Type.COUNTER) {
                if (name.endsWith("_total")) {
                    name = name.substring(0, name.length() - 6);
                }
                String withTotal = name + "_total";
                mungedSamples = new ArrayList<Sample>(samples.size());
                for (Sample s2 : samples) {
                    String n = s2.name;
                    if (name.equals(n)) {
                        n = withTotal;
                    }
                    mungedSamples.add(new Sample(n, s2.labelNames, s2.labelValues, s2.value, s2.exemplar, s2.timestampMs));
                }
            }
            this.name = name;
            this.unit = unit;
            this.type = type;
            this.help = help;
            this.samples = mungedSamples;
        }

        public MetricFamilySamples filter(Predicate<String> sampleNameFilter) {
            if (sampleNameFilter == null) {
                return this;
            }
            ArrayList<Sample> remainingSamples = new ArrayList<Sample>(this.samples.size());
            for (Sample sample : this.samples) {
                if (!sampleNameFilter.test(sample.name)) continue;
                remainingSamples.add(sample);
            }
            if (remainingSamples.isEmpty()) {
                return null;
            }
            return new MetricFamilySamples(this.name, this.unit, this.type, this.help, remainingSamples);
        }

        public String[] getNames() {
            switch (this.type) {
                case COUNTER: {
                    return new String[]{this.name + "_total", this.name + "_created", this.name};
                }
                case SUMMARY: {
                    return new String[]{this.name + "_count", this.name + "_sum", this.name + "_created", this.name};
                }
                case HISTOGRAM: {
                    return new String[]{this.name + "_count", this.name + "_sum", this.name + "_bucket", this.name + "_created", this.name};
                }
                case GAUGE_HISTOGRAM: {
                    return new String[]{this.name + "_gcount", this.name + "_gsum", this.name + "_bucket", this.name};
                }
                case INFO: {
                    return new String[]{this.name + "_info", this.name};
                }
            }
            return new String[]{this.name};
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetricFamilySamples)) {
                return false;
            }
            MetricFamilySamples other = (MetricFamilySamples)obj;
            return other.name.equals(this.name) && other.unit.equals(this.unit) && other.type.equals((Object)this.type) && other.help.equals(this.help) && other.samples.equals(this.samples);
        }

        public int hashCode() {
            int hash = 1;
            hash = 37 * hash + this.name.hashCode();
            hash = 37 * hash + this.unit.hashCode();
            hash = 37 * hash + this.type.hashCode();
            hash = 37 * hash + this.help.hashCode();
            hash = 37 * hash + this.samples.hashCode();
            return hash;
        }

        public String toString() {
            return "Name: " + this.name + " Unit:" + this.unit + " Type: " + (Object)((Object)this.type) + " Help: " + this.help + " Samples: " + this.samples;
        }

        public static class Sample {
            public final String name;
            public final List<String> labelNames;
            public final List<String> labelValues;
            public final double value;
            public final Exemplar exemplar;
            public final Long timestampMs;

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value, Exemplar exemplar, Long timestampMs) {
                this.name = name;
                this.labelNames = labelNames;
                this.labelValues = labelValues;
                this.value = value;
                this.exemplar = exemplar;
                this.timestampMs = timestampMs;
            }

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value, Long timestampMs) {
                this(name, labelNames, labelValues, value, null, timestampMs);
            }

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value, Exemplar exemplar) {
                this(name, labelNames, labelValues, value, exemplar, null);
            }

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value) {
                this(name, labelNames, labelValues, value, null, null);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Sample)) {
                    return false;
                }
                Sample other = (Sample)obj;
                return other.name.equals(this.name) && other.labelNames.equals(this.labelNames) && other.labelValues.equals(this.labelValues) && other.value == this.value && (this.exemplar == null && other.exemplar == null || other.exemplar != null && other.exemplar.equals(this.exemplar)) && (this.timestampMs == null && other.timestampMs == null || other.timestampMs != null && other.timestampMs.equals(this.timestampMs));
            }

            public int hashCode() {
                int hash = 1;
                hash = 37 * hash + this.name.hashCode();
                hash = 37 * hash + this.labelNames.hashCode();
                hash = 37 * hash + this.labelValues.hashCode();
                long d = Double.doubleToLongBits(this.value);
                hash = 37 * hash + (int)(d ^ d >>> 32);
                if (this.timestampMs != null) {
                    hash = 37 * hash + this.timestampMs.hashCode();
                }
                if (this.exemplar != null) {
                    hash = 37 * this.exemplar.hashCode();
                }
                return hash;
            }

            public String toString() {
                return "Name: " + this.name + " LabelNames: " + this.labelNames + " labelValues: " + this.labelValues + " Value: " + this.value + " TimestampMs: " + this.timestampMs;
            }
        }
    }

    public static enum Type {
        UNKNOWN,
        COUNTER,
        GAUGE,
        STATE_SET,
        INFO,
        HISTOGRAM,
        GAUGE_HISTOGRAM,
        SUMMARY;

    }
}

