/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.prometheus.client.hotspot;

import com.dremio.jdbc.shaded.io.prometheus.client.Collector;
import com.dremio.jdbc.shaded.io.prometheus.client.CounterMetricFamily;
import com.dremio.jdbc.shaded.io.prometheus.client.GaugeMetricFamily;
import com.dremio.jdbc.shaded.io.prometheus.client.Predicate;
import com.dremio.jdbc.shaded.io.prometheus.client.SampleNameFilter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class ClassLoadingExports
extends Collector {
    private static final String JVM_CLASSES_CURRENTLY_LOADED = "jvm_classes_currently_loaded";
    private static final String JVM_CLASSES_LOADED_TOTAL = "jvm_classes_loaded_total";
    private static final String JVM_CLASSES_UNLOADED_TOTAL = "jvm_classes_unloaded_total";
    private final ClassLoadingMXBean clBean;

    public ClassLoadingExports() {
        this(ManagementFactory.getClassLoadingMXBean());
    }

    public ClassLoadingExports(ClassLoadingMXBean clBean) {
        this.clBean = clBean;
    }

    void addClassLoadingMetrics(List<Collector.MetricFamilySamples> sampleFamilies, Predicate<String> nameFilter) {
        if (nameFilter.test(JVM_CLASSES_CURRENTLY_LOADED)) {
            sampleFamilies.add(new GaugeMetricFamily(JVM_CLASSES_CURRENTLY_LOADED, "The number of classes that are currently loaded in the JVM", this.clBean.getLoadedClassCount()));
        }
        if (nameFilter.test(JVM_CLASSES_LOADED_TOTAL)) {
            sampleFamilies.add(new CounterMetricFamily(JVM_CLASSES_LOADED_TOTAL, "The total number of classes that have been loaded since the JVM has started execution", this.clBean.getTotalLoadedClassCount()));
        }
        if (nameFilter.test(JVM_CLASSES_UNLOADED_TOTAL)) {
            sampleFamilies.add(new CounterMetricFamily(JVM_CLASSES_UNLOADED_TOTAL, "The total number of classes that have been unloaded since the JVM has started execution", this.clBean.getUnloadedClassCount()));
        }
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addClassLoadingMetrics(mfs, nameFilter == null ? SampleNameFilter.ALLOW_ALL : nameFilter);
        return mfs;
    }
}

