/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.io.protostuff;

import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonEncoding;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonFactory;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonParser;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonToken;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.io.IOContext;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.json.UTF8JsonGenerator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.json.UTF8StreamJsonParser;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.dremio.jdbc.shaded.io.protostuff.Input;
import com.dremio.jdbc.shaded.io.protostuff.JsonInput;
import com.dremio.jdbc.shaded.io.protostuff.JsonInputException;
import com.dremio.jdbc.shaded.io.protostuff.JsonOutput;
import com.dremio.jdbc.shaded.io.protostuff.LinkedBuffer;
import com.dremio.jdbc.shaded.io.protostuff.Output;
import com.dremio.jdbc.shaded.io.protostuff.Pipe;
import com.dremio.jdbc.shaded.io.protostuff.Schema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public final class JsonIOUtils {
    public static final Factory DEFAULT_JSON_FACTORY = new Factory();

    private JsonIOUtils() {
    }

    public static Pipe newPipe(byte[] data, boolean numeric) throws IOException {
        return JsonIOUtils.newPipe(data, 0, data.length, numeric);
    }

    public static Pipe newPipe(byte[] data, int offset, int length, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), data, false);
        UTF8StreamJsonParser parser = JsonIOUtils.newJsonParser(null, data, offset, offset + length, false, context);
        return JsonIOUtils.newPipe(parser, numeric);
    }

    public static Pipe newPipe(InputStream in, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), in, false);
        UTF8StreamJsonParser parser = JsonIOUtils.newJsonParser(in, context.allocReadIOBuffer(), 0, 0, true, context);
        return JsonIOUtils.newPipe(parser, numeric);
    }

    public static Pipe newPipe(Reader reader, boolean numeric) throws IOException {
        return JsonIOUtils.newPipe(DEFAULT_JSON_FACTORY.createJsonParser(reader), numeric);
    }

    public static Pipe newPipe(final JsonParser parser, boolean numeric) throws IOException {
        final JsonInput jsonInput = new JsonInput(parser, numeric);
        return new Pipe(){

            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                if (parser.nextToken() != JsonToken.START_OBJECT) {
                    throw new JsonInputException("Expected token: { but was " + String.valueOf((Object)parser.getCurrentToken()) + " on message " + pipeSchema.wrappedSchema.messageFullName());
                }
                return jsonInput;
            }

            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    parser.close();
                    return;
                }
                assert (input == jsonInput);
                JsonToken token = parser.getCurrentToken();
                parser.close();
                if (token != JsonToken.END_OBJECT) {
                    throw new JsonInputException("Expected token: } but was " + String.valueOf((Object)token) + " on message " + pipeSchema.wrappedSchema.messageFullName());
                }
            }
        };
    }

    public static UTF8StreamJsonParser newJsonParser(InputStream in, byte[] buf, int offset, int limit) throws IOException {
        return JsonIOUtils.newJsonParser(in, buf, offset, limit, false, new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), in, false));
    }

    static UTF8StreamJsonParser newJsonParser(InputStream in, byte[] buf, int offset, int limit, boolean bufferRecyclable, IOContext context) throws IOException {
        return new UTF8StreamJsonParser(context, DEFAULT_JSON_FACTORY.getParserFeatures(), in, DEFAULT_JSON_FACTORY.getCodec(), DEFAULT_JSON_FACTORY.getRootByteSymbols().makeChild(1), buf, offset, limit, bufferRecyclable);
    }

    public static UTF8JsonGenerator newJsonGenerator(OutputStream out, byte[] buf) {
        return JsonIOUtils.newJsonGenerator(out, buf, 0, false, new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), out, false));
    }

    static UTF8JsonGenerator newJsonGenerator(OutputStream out, byte[] buf, int offset, boolean bufferRecyclable, IOContext context) {
        context.setEncoding(JsonEncoding.UTF8);
        return new UTF8JsonGenerator(context, DEFAULT_JSON_FACTORY.getGeneratorFeatures(), DEFAULT_JSON_FACTORY.getCodec(), out, buf, offset, bufferRecyclable);
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema, boolean numeric) throws IOException {
        JsonIOUtils.mergeFrom(data, 0, data.length, message, schema, numeric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), data, false);
        try (UTF8StreamJsonParser parser = JsonIOUtils.newJsonParser(null, data, offset, offset + length, false, context);){
            JsonIOUtils.mergeFrom(parser, message, schema, numeric);
        }
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), in, false);
        try (UTF8StreamJsonParser parser = JsonIOUtils.newJsonParser(in, context.allocReadIOBuffer(), 0, 0, true, context);){
            JsonIOUtils.mergeFrom(parser, message, schema, numeric);
        }
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), in, false);
        try (UTF8StreamJsonParser parser = JsonIOUtils.newJsonParser(in, buffer.buffer, 0, 0, false, context);){
            JsonIOUtils.mergeFrom(parser, message, schema, numeric);
        }
    }

    public static <T> void mergeFrom(Reader reader, T message, Schema<T> schema, boolean numeric) throws IOException {
        try (JsonParser parser = DEFAULT_JSON_FACTORY.createJsonParser(reader);){
            JsonIOUtils.mergeFrom(parser, message, schema, numeric);
        }
    }

    public static <T> void mergeFrom(JsonParser parser, T message, Schema<T> schema, boolean numeric) throws IOException {
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonInputException("Expected token: { but was " + String.valueOf((Object)parser.getCurrentToken()) + " on message " + schema.messageFullName());
        }
        schema.mergeFrom((Input)new JsonInput(parser, numeric), message);
        if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            throw new JsonInputException("Expected token: } but was " + String.valueOf((Object)parser.getCurrentToken()) + " on message " + schema.messageFullName());
        }
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonIOUtils.writeTo(baos, message, schema, numeric);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return baos.toByteArray();
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonIOUtils.writeTo(baos, message, schema, numeric, buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return baos.toByteArray();
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), out, false);
        try (UTF8JsonGenerator generator = JsonIOUtils.newJsonGenerator(out, context.allocWriteEncodingBuffer(), 0, true, context);){
            JsonIOUtils.writeTo(generator, message, schema, numeric);
        }
    }

    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), out, false);
        try (UTF8JsonGenerator generator = JsonIOUtils.newJsonGenerator(out, buffer.buffer, 0, false, context);){
            JsonIOUtils.writeTo(generator, message, schema, numeric);
        }
    }

    public static <T> void writeTo(Writer writer, T message, Schema<T> schema, boolean numeric) throws IOException {
        try (JsonGenerator generator = DEFAULT_JSON_FACTORY.createJsonGenerator(writer);){
            JsonIOUtils.writeTo(generator, message, schema, numeric);
        }
    }

    public static <T> void writeTo(JsonGenerator generator, T message, Schema<T> schema, boolean numeric) throws IOException {
        generator.writeStartObject();
        JsonOutput output = new JsonOutput(generator, numeric, schema);
        schema.writeTo((Output)output, message);
        if (output.isLastRepeated()) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), out, false);
        try (UTF8JsonGenerator generator = JsonIOUtils.newJsonGenerator(out, context.allocWriteEncodingBuffer(), 0, true, context);){
            JsonIOUtils.writeListTo(generator, messages, schema, numeric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeListTo(OutputStream out, List<T> messages, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), out, false);
        try (UTF8JsonGenerator generator = JsonIOUtils.newJsonGenerator(out, buffer.buffer, 0, false, context);){
            JsonIOUtils.writeListTo(generator, messages, schema, numeric);
        }
    }

    public static <T> void writeListTo(Writer writer, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        try (JsonGenerator generator = DEFAULT_JSON_FACTORY.createJsonGenerator(writer);){
            JsonIOUtils.writeListTo(generator, messages, schema, numeric);
        }
    }

    public static <T> void writeListTo(JsonGenerator generator, List<T> messages, Schema<T> schema, boolean numeric) throws IOException {
        generator.writeStartArray();
        if (messages.isEmpty()) {
            generator.writeEndArray();
            return;
        }
        JsonOutput output = new JsonOutput(generator, numeric, schema);
        for (T m4 : messages) {
            generator.writeStartObject();
            schema.writeTo((Output)output, m4);
            if (output.isLastRepeated()) {
                generator.writeEndArray();
            }
            generator.writeEndObject();
            output.reset();
        }
        generator.writeEndArray();
    }

    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), in, false);
        try (UTF8StreamJsonParser parser = JsonIOUtils.newJsonParser(in, context.allocReadIOBuffer(), 0, 0, true, context);){
            List<T> list = JsonIOUtils.parseListFrom(parser, schema, numeric);
            return list;
        }
    }

    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema, boolean numeric, LinkedBuffer buffer) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), in, false);
        try (UTF8StreamJsonParser parser = JsonIOUtils.newJsonParser(in, buffer.buffer, 0, 0, false, context);){
            List<T> list = JsonIOUtils.parseListFrom(parser, schema, numeric);
            return list;
        }
    }

    public static <T> List<T> parseListFrom(Reader reader, Schema<T> schema, boolean numeric) throws IOException {
        try (JsonParser parser = DEFAULT_JSON_FACTORY.createJsonParser(reader);){
            List<T> list = JsonIOUtils.parseListFrom(parser, schema, numeric);
            return list;
        }
    }

    public static <T> List<T> parseListFrom(JsonParser parser, Schema<T> schema, boolean numeric) throws IOException {
        if (parser.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonInputException("Expected token: [ but was " + String.valueOf((Object)parser.getCurrentToken()) + " on message: " + schema.messageFullName());
        }
        JsonInput input = new JsonInput(parser, numeric);
        ArrayList<Object> list = new ArrayList<Object>();
        JsonToken t2 = parser.nextToken();
        while (t2 != JsonToken.END_ARRAY) {
            if (t2 != JsonToken.START_OBJECT) {
                throw new JsonInputException("Expected token: { but was " + String.valueOf((Object)parser.getCurrentToken()) + " on message " + schema.messageFullName());
            }
            Object message = schema.newMessage();
            schema.mergeFrom((Input)input, message);
            if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                throw new JsonInputException("Expected token: } but was " + String.valueOf((Object)parser.getCurrentToken()) + " on message " + schema.messageFullName());
            }
            list.add(message);
            input.reset();
            t2 = parser.nextToken();
        }
        return list;
    }

    static {
        DEFAULT_JSON_FACTORY.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        DEFAULT_JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    public static final class Factory
    extends JsonFactory {
        public ByteQuadsCanonicalizer getRootByteSymbols() {
            return this._byteSymbolCanonicalizer;
        }
    }
}

