/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseVariableWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BitVectorHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVectorHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public abstract class BaseValueVectorHelper<T extends FieldVector>
implements ValueVectorHelper {
    private final Mode mode;
    protected final T vector;
    private final BaseFixedWidthVector fixedVector;
    private final BaseVariableWidthVector variableVector;
    private final IntConsumer countSetter;
    private final Consumer<ArrowBuf> validitySetter;

    public BaseValueVectorHelper(T vector) {
        this.vector = vector;
        if (vector instanceof BaseFixedWidthVector) {
            this.fixedVector = (BaseFixedWidthVector)vector;
            this.countSetter = i -> {
                this.fixedVector.valueCount = i;
            };
            this.validitySetter = i -> {
                this.fixedVector.validityBuffer = i;
            };
            this.variableVector = null;
            this.mode = Mode.FIXED;
        } else if (vector instanceof BaseVariableWidthVector) {
            this.variableVector = (BaseVariableWidthVector)vector;
            this.countSetter = i -> {
                this.variableVector.valueCount = i;
            };
            this.validitySetter = i -> {
                this.variableVector.validityBuffer = i;
            };
            this.fixedVector = null;
            this.mode = Mode.VARIABLE;
        } else {
            this.mode = Mode.OTHER;
            this.fixedVector = null;
            this.variableVector = null;
            this.countSetter = i -> {
                throw new UnsupportedOperationException();
            };
            this.validitySetter = i -> {
                throw new UnsupportedOperationException();
            };
        }
    }

    private final boolean checkFixedOrVariable() {
        switch (this.mode.ordinal()) {
            default: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().build();
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName(this.vector.getField().getName()).build()).setValueCount(this.vector.getValueCount()).setBufferLength(this.vector.getBufferSize());
    }

    public static int getValidityBufferSizeFromCount(int valueCount) {
        return (int)Math.ceil((double)valueCount / 8.0);
    }

    protected UserBitShared.SerializedField buildValidityMetadata() {
        UserBitShared.SerializedField.Builder validityBuilder = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("$bits$").build()).setValueCount(this.vector.getValueCount()).setBufferLength(BaseValueVectorHelper.getValidityBufferSizeFromCount(this.vector.getValueCount())).setMajorType(TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(TypeProtos.MinorType.BIT));
        return validityBuilder.build();
    }

    @Override
    public void loadFromValidityAndDataBuffers(UserBitShared.SerializedField metadata, ArrowBuf dataBuffer, ArrowBuf validityBuffer) {
        if (!this.checkFixedOrVariable()) {
            throw new UnsupportedOperationException("this loader is not supported for variable width vectors");
        }
        this.vector.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        this.loadValidityBuffer(bitsField, validityBuffer);
        this.loadDataAndPossiblyOffsetBuffer(valuesField, dataBuffer);
        this.countSetter.accept(metadata.getValueCount());
    }

    private void loadValidityBuffer(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        int valueCount = metadata.getValueCount();
        int actualLength = metadata.getBufferLength();
        int expectedLength = BaseValueVectorHelper.getValidityBufferSizeFromCount(valueCount);
        assert (expectedLength == actualLength) : String.format("Expected to load %d bytes but actually loaded %d bytes in validity buffer", expectedLength, actualLength);
        ArrowBuf validity = buffer.slice(0L, actualLength);
        validity.writerIndex(actualLength);
        validity.getReferenceManager().retain(1);
        this.validitySetter.accept(validity);
    }

    @Override
    public void loadData(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        this.vector.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        long valuesLength = buffer.capacity();
        if (this.checkFixedOrVariable()) {
            this.fixedVector.allocateNew(metadata.getValueCount());
        } else {
            this.variableVector.allocateNew(valuesLength, metadata.getValueCount());
        }
        this.setValidityBuffer(bitsField);
        if (this.checkFixedOrVariable()) {
            this.fixedVector.valueBuffer.close();
            this.loadDataAndPossiblyOffsetBuffer(valuesField, buffer.slice(0L, valuesLength));
        } else {
            this.variableVector.offsetBuffer.close();
            this.variableVector.valueBuffer.close();
            this.loadDataAndPossiblyOffsetBuffer(valuesField, buffer.slice(0L, valuesLength));
            this.variableVector.setLastSet(metadata.getValueCount() - 1);
        }
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        this.vector.clear();
        UserBitShared.SerializedField bitsField = metadata.getChild(0);
        UserBitShared.SerializedField valuesField = metadata.getChild(1);
        long bitsLength = bitsField.getBufferLength();
        long capacity = buffer.capacity();
        long valuesLength = capacity - bitsLength;
        this.loadValidityBuffer(bitsField, buffer);
        this.loadDataAndPossiblyOffsetBuffer(valuesField, buffer.slice(bitsLength, valuesLength));
        if (!this.checkFixedOrVariable()) {
            this.variableVector.setLastSet(metadata.getValueCount() - 1);
        }
        this.countSetter.accept(metadata.getValueCount());
    }

    protected abstract void loadDataAndPossiblyOffsetBuffer(UserBitShared.SerializedField var1, ArrowBuf var2);

    private void setValidityBuffer(UserBitShared.SerializedField metadata) {
        int valueCount = metadata.getValueCount();
        int actualLength = metadata.getBufferLength();
        int expectedLength = BaseValueVectorHelper.getValidityBufferSizeFromCount(valueCount);
        assert (expectedLength == actualLength) : String.format("Expected to load %d bytes but actually set %d bytes in validity buffer", expectedLength, actualLength);
        for (int index = 0; index < valueCount; ++index) {
            BitVectorHelper.setBit(this.validityBuffer(), index);
        }
        this.validityBuffer().writerIndex(actualLength);
    }

    private ArrowBuf validityBuffer() {
        return this.vector.getValidityBuffer();
    }

    @Override
    public void materialize(Field field) {
        throw new UnsupportedOperationException();
    }

    private static enum Mode {
        FIXED,
        VARIABLE,
        OTHER;

    }
}

