/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector;

import com.dremio.jdbc.shaded.io.netty.buffer.ByteBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class DecimalHelper {
    public static final int MAX_DIGITS = 9;
    public static final int DIGITS_BASE = 1000000000;
    public static final int INTEGER_SIZE = 4;
    public static final BigDecimal BASE_BIGDECIMAL = new BigDecimal(1000000000);
    public static final BigInteger BASE_BIGINT = BigInteger.valueOf(1000000000L);

    public static void swapBytes(byte[] bytes) {
        int i = 0;
        for (int j = bytes.length - 1; i < j; ++i, --j) {
            byte temp = bytes[i];
            bytes[i] = bytes[j];
            bytes[j] = temp;
        }
    }

    public static BigDecimal getBigDecimalFromBEArrowBuf(ArrowBuf buffer, int index, int scale) {
        int length = 16;
        int startIndex = index * 16;
        byte[] value = new byte[16];
        buffer.getBytes((long)startIndex, value, 0, 16);
        BigInteger unscaledValue = new BigInteger(value);
        return new BigDecimal(unscaledValue, scale);
    }

    public static void getSparseFromBigDecimal(BigDecimal input, ByteBuf data, int startIndex, int scale, int nDecimalDigits) {
        for (int i = 0; i < nDecimalDigits; ++i) {
            data.setInt(startIndex + i * 4, 0);
        }
        boolean sign = false;
        if (input.signum() == -1) {
            sign = true;
            input = input.abs();
        }
        input = input.setScale(scale, RoundingMode.HALF_UP);
        BigDecimal integerPart = input.setScale(0, RoundingMode.DOWN);
        int destIndex = nDecimalDigits - DecimalHelper.roundUp(scale) - 1;
        while (integerPart.compareTo(BigDecimal.ZERO) > 0) {
            data.setInt(startIndex + destIndex * 4, integerPart.remainder(BASE_BIGDECIMAL).intValue());
            --destIndex;
            integerPart = integerPart.divide(BASE_BIGDECIMAL).setScale(0, RoundingMode.DOWN);
        }
        int actualDigits = scale % 9;
        if (actualDigits != 0) {
            input = input.setScale(scale += 9 - actualDigits, RoundingMode.DOWN);
        }
        BigDecimal fractionalPart = input.remainder(BigDecimal.ONE).movePointRight(scale);
        destIndex = nDecimalDigits - 1;
        while (scale > 0) {
            fractionalPart = fractionalPart.movePointLeft(9);
            BigDecimal temp = fractionalPart.remainder(BigDecimal.ONE);
            data.setInt(startIndex + destIndex * 4, temp.unscaledValue().intValue());
            --destIndex;
            fractionalPart = fractionalPart.setScale(0, RoundingMode.DOWN);
            scale -= 9;
        }
        if (sign) {
            data.setInt(startIndex, data.getInt(startIndex) | Integer.MIN_VALUE);
        }
    }

    public static BigDecimal getBigDecimalFromSparse(ByteBuf data, int startIndex, int nDecimalDigits, int scale) {
        int actualDigits;
        BigInteger decimalDigits = BigInteger.valueOf(data.getInt(startIndex) & Integer.MAX_VALUE);
        for (int i = 1; i < nDecimalDigits; ++i) {
            BigInteger temp = BigInteger.valueOf(data.getInt(startIndex + i * 4));
            decimalDigits = decimalDigits.multiply(BASE_BIGINT);
            decimalDigits = decimalDigits.add(temp);
        }
        if (scale > 0 && (actualDigits = scale % 9) != 0) {
            BigInteger truncate = BigInteger.valueOf((int)Math.pow(10.0, 9 - actualDigits));
            decimalDigits = decimalDigits.divide(truncate);
        }
        if ((data.getInt(startIndex) & Integer.MIN_VALUE) != 0) {
            decimalDigits = decimalDigits.negate();
        }
        BigDecimal decimal = new BigDecimal(decimalDigits, scale);
        return decimal;
    }

    public static int roundUp(int ndigits) {
        return (ndigits + 9 - 1) / 9;
    }

    private DecimalHelper() {
    }
}

