/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector;

import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.common.util.MajorTypeHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseValueVectorHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BitVector;

public class FixedWidthVectorHelper<T extends BaseFixedWidthVector>
extends BaseValueVectorHelper<T> {
    private final int size;
    private final boolean bitVector;

    public FixedWidthVectorHelper(T vector) {
        super(vector);
        this.size = ((BaseFixedWidthVector)vector).getTypeWidth();
        this.bitVector = vector instanceof BitVector;
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.buildValidityMetadata()).addChild(this.buildDataMetadata()).setMajorType(MajorTypeHelper.getMajorTypeForField(((BaseFixedWidthVector)this.vector).getField()));
    }

    @Override
    protected void loadDataAndPossiblyOffsetBuffer(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = this.bitVector ? FixedWidthVectorHelper.getValidityBufferSizeFromCount(valueCount) : valueCount * this.size;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes in data buffer", expectedLength, actualLength);
        ((BaseFixedWidthVector)this.vector).valueBuffer = buffer.slice(0L, actualLength);
        ((BaseFixedWidthVector)this.vector).valueBuffer.getReferenceManager().retain();
        ((BaseFixedWidthVector)this.vector).valueBuffer.writerIndex(actualLength);
        ((BaseFixedWidthVector)this.vector).refreshValueCapacity();
    }

    private UserBitShared.SerializedField buildDataMetadata() {
        UserBitShared.SerializedField.Builder dataBuilder = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("$values$").build()).setValueCount(((BaseFixedWidthVector)this.vector).valueCount).setMajorType(Types.required(CompleteType.fromField(((BaseFixedWidthVector)this.vector).getField()).toMinorType()));
        if (this.bitVector) {
            dataBuilder.setBufferLength(FixedWidthVectorHelper.getValidityBufferSizeFromCount(((BaseFixedWidthVector)this.vector).valueCount));
        } else {
            dataBuilder.setBufferLength(((BaseFixedWidthVector)this.vector).valueCount * this.size);
        }
        return dataBuilder.build();
    }
}

