/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector;

import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.common.util.MajorTypeHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseValueVectorHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseVariableWidthVector;

public class VariableWidthVectorHelper<T extends BaseVariableWidthVector>
extends BaseValueVectorHelper<T> {
    public VariableWidthVectorHelper(T vector) {
        super(vector);
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return super.getMetadataBuilder().addChild(this.buildValidityMetadata()).addChild(this.buildOffsetAndDataMetadata()).setMajorType(MajorTypeHelper.getMajorTypeForField(((BaseVariableWidthVector)this.vector).getField()));
    }

    private UserBitShared.SerializedField buildOffsetAndDataMetadata() {
        UserBitShared.SerializedField offsetField = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("$offsets$").build()).setValueCount(((BaseVariableWidthVector)this.vector).valueCount == 0 ? 0 : ((BaseVariableWidthVector)this.vector).valueCount + 1).setBufferLength(((BaseVariableWidthVector)this.vector).valueCount == 0 ? 0 : (((BaseVariableWidthVector)this.vector).valueCount + 1) * 4).setMajorType(Types.required(TypeProtos.MinorType.UINT4)).build();
        UserBitShared.SerializedField.Builder dataBuilder = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("$values$").build()).setValueCount(((BaseVariableWidthVector)this.vector).valueCount).setBufferLength(((BaseVariableWidthVector)this.vector).getBufferSize() - VariableWidthVectorHelper.getValidityBufferSizeFromCount(((BaseVariableWidthVector)this.vector).valueCount)).addChild(offsetField).setMajorType(Types.required(CompleteType.fromField(((BaseVariableWidthVector)this.vector).getField()).toMinorType()));
        return dataBuilder.build();
    }

    @Override
    public void loadDataAndPossiblyOffsetBuffer(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        UserBitShared.SerializedField offsetField = metadata.getChild(0);
        int offsetActualLength = offsetField.getBufferLength();
        int valueCount = offsetField.getValueCount();
        int offsetExpectedLength = valueCount * 4;
        assert (offsetActualLength == offsetExpectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes in offset buffer", offsetExpectedLength, offsetActualLength);
        ((BaseVariableWidthVector)this.vector).offsetBuffer = buffer.slice(0L, offsetActualLength);
        ((BaseVariableWidthVector)this.vector).offsetBuffer.getReferenceManager().retain();
        ((BaseVariableWidthVector)this.vector).offsetBuffer.writerIndex(offsetActualLength);
        long capacity = buffer.capacity();
        long dataLength = capacity - (long)offsetActualLength;
        ((BaseVariableWidthVector)this.vector).valueBuffer = buffer.slice(offsetActualLength, dataLength);
        ((BaseVariableWidthVector)this.vector).valueBuffer.getReferenceManager().retain();
        ((BaseVariableWidthVector)this.vector).valueBuffer.writerIndex(dataLength);
    }
}

