/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector;

import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.util.Collections2;
import com.dremio.jdbc.shaded.org.apache.arrow.util.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseVariableWidthViewVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TypeLayout;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compression.CompressionCodec;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compression.CompressionUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compression.NoCompressionCodec;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class VectorLoader {
    private final VectorSchemaRoot root;
    private final CompressionCodec.Factory factory;
    private boolean decompressionNeeded;

    public VectorLoader(VectorSchemaRoot root) {
        this(root, CompressionCodec.Factory.INSTANCE);
    }

    public VectorLoader(VectorSchemaRoot root, CompressionCodec.Factory factory) {
        this.root = root;
        this.factory = factory;
    }

    public void load(ArrowRecordBatch recordBatch) {
        Iterator<ArrowBuf> buffers = recordBatch.getBuffers().iterator();
        Iterator<ArrowFieldNode> nodes = recordBatch.getNodes().iterator();
        CompressionUtil.CodecType codecType = CompressionUtil.CodecType.fromCompressionType(recordBatch.getBodyCompression().getCodec());
        this.decompressionNeeded = codecType != CompressionUtil.CodecType.NO_COMPRESSION;
        NoCompressionCodec codec = this.decompressionNeeded ? this.factory.createCodec(codecType) : NoCompressionCodec.INSTANCE;
        Iterator<Long> variadicBufferCounts = Collections.emptyIterator();
        if (recordBatch.getVariadicBufferCounts() != null && !recordBatch.getVariadicBufferCounts().isEmpty()) {
            variadicBufferCounts = recordBatch.getVariadicBufferCounts().iterator();
        }
        for (FieldVector fieldVector : this.root.getFieldVectors()) {
            this.loadBuffers(fieldVector, fieldVector.getField(), buffers, nodes, codec, variadicBufferCounts);
        }
        this.root.setRowCount(recordBatch.getLength());
        if (nodes.hasNext() || buffers.hasNext() || variadicBufferCounts.hasNext()) {
            throw new IllegalArgumentException("not all nodes, buffers and variadicBufferCounts were consumed. nodes: " + Collections2.toString(nodes) + " buffers: " + Collections2.toString(buffers) + " variadicBufferCounts: " + Collections2.toString(variadicBufferCounts));
        }
    }

    private void loadBuffers(FieldVector vector, Field field, Iterator<ArrowBuf> buffers, Iterator<ArrowFieldNode> nodes, CompressionCodec codec, Iterator<Long> variadicBufferCounts) {
        Preconditions.checkArgument(nodes.hasNext(), "no more field nodes for field %s and vector %s", (Object)field, (Object)vector);
        ArrowFieldNode fieldNode = nodes.next();
        long variadicBufferLayoutCount = 0L;
        if (vector instanceof BaseVariableWidthViewVector) {
            if (variadicBufferCounts.hasNext()) {
                variadicBufferLayoutCount = variadicBufferCounts.next();
            } else {
                throw new IllegalStateException("No variadicBufferCounts available for BaseVariableWidthViewVector");
            }
        }
        int bufferLayoutCount = (int)(variadicBufferLayoutCount + (long)TypeLayout.getTypeBufferCount(field.getType()));
        ArrayList<ArrowBuf> ownBuffers = new ArrayList<ArrowBuf>(bufferLayoutCount);
        for (int j = 0; j < bufferLayoutCount; ++j) {
            ArrowBuf nextBuf = buffers.next();
            ArrowBuf bufferToAdd = nextBuf.writerIndex() > 0L ? codec.decompress(vector.getAllocator(), nextBuf) : nextBuf;
            ownBuffers.add(bufferToAdd);
            if (!this.decompressionNeeded) continue;
            nextBuf.getReferenceManager().retain();
        }
        try {
            vector.loadFieldBuffers(fieldNode, ownBuffers);
            if (this.decompressionNeeded) {
                for (ArrowBuf buf : ownBuffers) {
                    buf.close();
                }
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load buffers for field " + String.valueOf(field) + ". error message: " + e.getMessage(), e);
        }
        List<Field> children = field.getChildren();
        if (children.size() > 0) {
            List<FieldVector> childrenFromFields = vector.getChildrenFromFields();
            Preconditions.checkArgument(children.size() == childrenFromFields.size(), "should have as many children as in the schema: found %s expected %s", childrenFromFields.size(), children.size());
            for (int i = 0; i < childrenFromFields.size(); ++i) {
                Field child = children.get(i);
                FieldVector fieldVector = childrenFromFields.get(i);
                this.loadBuffers(fieldVector, child, buffers, nodes, codec, variadicBufferCounts);
            }
        }
    }
}

