/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.compare;

import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.ByteFunctionHelpers;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.util.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseLargeVariableWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseVariableWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseVariableWidthViewVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BitVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ExtensionTypeVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.NullVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compare.Range;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compare.TypeEqualsVisitor;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compare.VectorVisitor;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.DenseUnionVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.FixedSizeListVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.LargeListVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.LargeListViewVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.ListVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.ListViewVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.NonNullableStructVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.RunEndEncodedVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.StructVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.UnionVector;
import java.util.List;
import java.util.function.BiFunction;

public class RangeEqualsVisitor
implements VectorVisitor<Boolean, Range> {
    private ValueVector left;
    private ValueVector right;
    private BiFunction<ValueVector, ValueVector, Boolean> typeComparator;
    private boolean typeCompareResult;
    public static final BiFunction<ValueVector, ValueVector, Boolean> DEFAULT_TYPE_COMPARATOR = (v1, v2) -> new TypeEqualsVisitor((ValueVector)v2).equals((ValueVector)v1);

    public RangeEqualsVisitor(ValueVector left, ValueVector right) {
        this(left, right, DEFAULT_TYPE_COMPARATOR);
    }

    public RangeEqualsVisitor(ValueVector left, ValueVector right, BiFunction<ValueVector, ValueVector, Boolean> typeComparator) {
        this.left = left;
        this.right = right;
        this.typeComparator = typeComparator;
        Preconditions.checkArgument(left != null, "left vector cannot be null");
        Preconditions.checkArgument(right != null, "right vector cannot be null");
        this.checkType();
    }

    private void checkType() {
        this.typeCompareResult = this.typeComparator == null || this.left == this.right ? true : this.typeComparator.apply(this.left, this.right);
    }

    protected boolean validate(ValueVector left) {
        if (left != this.left) {
            this.left = left;
            this.checkType();
        }
        return this.typeCompareResult;
    }

    public boolean rangeEquals(Range range) {
        if (!this.typeCompareResult) {
            return false;
        }
        Preconditions.checkArgument(range.getLeftStart() >= 0, "leftStart %s must be non negative.", range.getLeftStart());
        Preconditions.checkArgument(range.getRightStart() >= 0, "rightStart %s must be non negative.", range.getRightStart());
        Preconditions.checkArgument(range.getRightStart() + range.getLength() <= this.right.getValueCount(), "(rightStart + length) %s out of range[0, %s].", range.getRightStart() + range.getLength(), this.right.getValueCount());
        Preconditions.checkArgument(range.getLeftStart() + range.getLength() <= this.left.getValueCount(), "(leftStart + length) %s out of range[0, %s].", range.getLeftStart() + range.getLength(), this.left.getValueCount());
        return this.left.accept(this, range);
    }

    public ValueVector getLeft() {
        return this.left;
    }

    public ValueVector getRight() {
        return this.right;
    }

    @Override
    public Boolean visit(BaseFixedWidthVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareBaseFixedWidthVectors(range);
    }

    @Override
    public Boolean visit(BaseVariableWidthVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareBaseVariableWidthVectors(range);
    }

    @Override
    public Boolean visit(BaseLargeVariableWidthVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareBaseLargeVariableWidthVectors(range);
    }

    @Override
    public Boolean visit(BaseVariableWidthViewVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareBaseVariableWidthViewVectors(range);
    }

    @Override
    public Boolean visit(ListVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareListVectors(range);
    }

    @Override
    public Boolean visit(FixedSizeListVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareFixedSizeListVectors(range);
    }

    @Override
    public Boolean visit(LargeListVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareLargeListVectors(range);
    }

    @Override
    public Boolean visit(NonNullableStructVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareStructVectors(range);
    }

    @Override
    public Boolean visit(UnionVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareUnionVectors(range);
    }

    @Override
    public Boolean visit(DenseUnionVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareDenseUnionVectors(range);
    }

    @Override
    public Boolean visit(NullVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(RunEndEncodedVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareRunEndEncodedVectors(range);
    }

    @Override
    public Boolean visit(ExtensionTypeVector<?> left, Range range) {
        if (!(this.right instanceof ExtensionTypeVector) || !this.validate(left)) {
            return false;
        }
        Object rightUnderlying = ((ExtensionTypeVector)this.right).getUnderlyingVector();
        TypeEqualsVisitor typeVisitor = new TypeEqualsVisitor((ValueVector)rightUnderlying);
        RangeEqualsVisitor underlyingVisitor = this.createInnerVisitor((ValueVector)left.getUnderlyingVector(), (ValueVector)rightUnderlying, (l, r) -> typeVisitor.equals((ValueVector)l));
        return underlyingVisitor.rangeEquals(range);
    }

    @Override
    public Boolean visit(ListViewVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareListViewVectors(range);
    }

    @Override
    public Boolean visit(LargeListViewVector left, Range range) {
        if (!this.validate(left)) {
            return false;
        }
        return this.compareLargeListViewVectors(range);
    }

    protected boolean compareRunEndEncodedVectors(Range range) {
        RunEndEncodedVector leftVector = (RunEndEncodedVector)this.left;
        RunEndEncodedVector rightVector = (RunEndEncodedVector)this.right;
        int leftRangeEnd = range.getLeftStart() + range.getLength();
        int rightRangeEnd = range.getRightStart() + range.getLength();
        FieldVector leftValuesVector = leftVector.getValuesVector();
        FieldVector rightValuesVector = rightVector.getValuesVector();
        RangeEqualsVisitor innerVisitor = this.createInnerVisitor(leftValuesVector, rightValuesVector, null);
        int leftLogicalIndex = range.getLeftStart();
        int rightLogicalIndex = range.getRightStart();
        while (leftLogicalIndex < leftRangeEnd) {
            int rightPhysicalIndex;
            int leftPhysicalIndex = leftVector.getPhysicalIndex(leftLogicalIndex);
            if (leftValuesVector.accept(innerVisitor, new Range(leftPhysicalIndex, rightPhysicalIndex = rightVector.getPhysicalIndex(rightLogicalIndex), 1)).booleanValue()) {
                int rightRunLength;
                int leftRunEnd = leftVector.getRunEnd(leftLogicalIndex);
                int rightRunEnd = rightVector.getRunEnd(rightLogicalIndex);
                int leftRunLength = Math.min(leftRunEnd, leftRangeEnd) - leftLogicalIndex;
                if (leftRunLength != (rightRunLength = Math.min(rightRunEnd, rightRangeEnd) - rightLogicalIndex)) {
                    return false;
                }
                leftLogicalIndex = leftRunEnd;
                rightLogicalIndex = rightRunEnd;
                continue;
            }
            return false;
        }
        return true;
    }

    protected RangeEqualsVisitor createInnerVisitor(ValueVector leftInner, ValueVector rightInner, BiFunction<ValueVector, ValueVector, Boolean> typeComparator) {
        return new RangeEqualsVisitor(leftInner, rightInner, typeComparator);
    }

    protected boolean compareUnionVectors(Range range) {
        UnionVector leftVector = (UnionVector)this.left;
        UnionVector rightVector = (UnionVector)this.right;
        Range subRange = new Range(0, 0, 1);
        for (int i = 0; i < range.getLength(); ++i) {
            subRange.setLeftStart(range.getLeftStart() + i).setRightStart(range.getRightStart() + i);
            ValueVector leftSubVector = leftVector.getVector(range.getLeftStart() + i);
            ValueVector rightSubVector = rightVector.getVector(range.getRightStart() + i);
            if (leftSubVector == null || rightSubVector == null) {
                if (leftSubVector == rightSubVector) continue;
                return false;
            }
            TypeEqualsVisitor typeVisitor = new TypeEqualsVisitor(rightSubVector);
            RangeEqualsVisitor visitor = this.createInnerVisitor(leftSubVector, rightSubVector, (left, right) -> typeVisitor.equals((ValueVector)left));
            if (visitor.rangeEquals(subRange)) continue;
            return false;
        }
        return true;
    }

    protected boolean compareDenseUnionVectors(Range range) {
        DenseUnionVector leftVector = (DenseUnionVector)this.left;
        DenseUnionVector rightVector = (DenseUnionVector)this.right;
        Range subRange = new Range(0, 0, 1);
        for (int i = 0; i < range.getLength(); ++i) {
            byte rightTypeId;
            boolean isLeftNull = leftVector.isNull(range.getLeftStart() + i);
            boolean isRightNull = rightVector.isNull(range.getRightStart() + i);
            if (isLeftNull || isRightNull) {
                if (isLeftNull == isRightNull) continue;
                return false;
            }
            byte leftTypeId = leftVector.getTypeId(range.getLeftStart() + i);
            if (leftTypeId != (rightTypeId = rightVector.getTypeId(range.getRightStart() + i))) {
                return false;
            }
            ValueVector leftSubVector = leftVector.getVectorByType(leftTypeId);
            ValueVector rightSubVector = rightVector.getVectorByType(rightTypeId);
            if (leftSubVector == null || rightSubVector == null) {
                if (leftSubVector == rightSubVector) continue;
                return false;
            }
            int leftOffset = leftVector.getOffset(range.getLeftStart() + i);
            int rightOffset = rightVector.getOffset(range.getRightStart() + i);
            subRange.setLeftStart(leftOffset).setRightStart(rightOffset);
            TypeEqualsVisitor typeVisitor = new TypeEqualsVisitor(rightSubVector);
            RangeEqualsVisitor visitor = this.createInnerVisitor(leftSubVector, rightSubVector, (left, right) -> typeVisitor.equals((ValueVector)left));
            if (visitor.rangeEquals(subRange)) continue;
            return false;
        }
        return true;
    }

    private boolean compareStructVectorsInternal(NonNullableStructVector leftVector, NonNullableStructVector rightVector, Range range) {
        List<String> leftChildNames = leftVector.getChildFieldNames();
        for (String name : leftChildNames) {
            RangeEqualsVisitor visitor = this.createInnerVisitor(leftVector.getChild(name), rightVector.getChild(name), null);
            if (visitor.rangeEquals(range)) continue;
            return false;
        }
        return true;
    }

    protected boolean compareStructVectors(Range range) {
        NonNullableStructVector leftVector = (NonNullableStructVector)this.left;
        NonNullableStructVector rightVector = (NonNullableStructVector)this.right;
        List<String> leftChildNames = leftVector.getChildFieldNames();
        if (!leftChildNames.equals(rightVector.getChildFieldNames())) {
            return false;
        }
        if (!(leftVector instanceof StructVector) && !(rightVector instanceof StructVector)) {
            return this.compareStructVectorsInternal(leftVector, rightVector, range);
        }
        Range subRange = new Range(0, 0, 0);
        boolean lastIsNull = true;
        int lastNullIndex = -1;
        for (int i = 0; i < range.getLength(); ++i) {
            boolean isRightNull;
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isLeftNull = leftVector.isNull(leftIndex);
            if (isLeftNull != (isRightNull = rightVector.isNull(rightIndex))) {
                return false;
            }
            if (isLeftNull) {
                if (!lastIsNull) {
                    subRange.setLeftStart(range.getLeftStart() + lastNullIndex + 1).setRightStart(range.getRightStart() + lastNullIndex + 1).setLength(i - (lastNullIndex + 1));
                    if (!this.compareStructVectorsInternal(leftVector, rightVector, subRange)) {
                        return false;
                    }
                }
                lastIsNull = true;
                lastNullIndex = i;
                continue;
            }
            lastIsNull = false;
        }
        if (!lastIsNull) {
            subRange.setLeftStart(range.getLeftStart() + lastNullIndex + 1).setRightStart(range.getRightStart() + lastNullIndex + 1).setLength(range.getLength() - (lastNullIndex + 1));
            return this.compareStructVectorsInternal(leftVector, rightVector, subRange);
        }
        return true;
    }

    protected boolean compareBaseFixedWidthVectors(Range range) {
        BaseFixedWidthVector leftVector = (BaseFixedWidthVector)this.left;
        BaseFixedWidthVector rightVector = (BaseFixedWidthVector)this.right;
        for (int i = 0; i < range.getLength(); ++i) {
            boolean ret;
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            int typeWidth = leftVector.getTypeWidth();
            if (isNull) continue;
            if (!(leftVector instanceof BitVector)) {
                int startIndexLeft = typeWidth * leftIndex;
                int endIndexLeft = typeWidth * (leftIndex + 1);
                int startIndexRight = typeWidth * rightIndex;
                int endIndexRight = typeWidth * (rightIndex + 1);
                int ret2 = ByteFunctionHelpers.equal(leftVector.getDataBuffer(), startIndexLeft, endIndexLeft, rightVector.getDataBuffer(), startIndexRight, endIndexRight);
                if (ret2 != 0) continue;
                return false;
            }
            boolean bl = ret = ((BitVector)leftVector).get(leftIndex) == ((BitVector)rightVector).get(rightIndex);
            if (ret) continue;
            return false;
        }
        return true;
    }

    protected boolean compareBaseVariableWidthVectors(Range range) {
        BaseVariableWidthVector leftVector = (BaseVariableWidthVector)this.left;
        BaseVariableWidthVector rightVector = (BaseVariableWidthVector)this.right;
        for (int i = 0; i < range.getLength(); ++i) {
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            int offsetWidth = 4;
            if (isNull) continue;
            int startIndexLeft = leftVector.getOffsetBuffer().getInt(leftIndex * offsetWidth);
            int endIndexLeft = leftVector.getOffsetBuffer().getInt((leftIndex + 1) * offsetWidth);
            int startIndexRight = rightVector.getOffsetBuffer().getInt(rightIndex * offsetWidth);
            int endIndexRight = rightVector.getOffsetBuffer().getInt((rightIndex + 1) * offsetWidth);
            int ret = ByteFunctionHelpers.equal(leftVector.getDataBuffer(), startIndexLeft, endIndexLeft, rightVector.getDataBuffer(), startIndexRight, endIndexRight);
            if (ret != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean compareBaseLargeVariableWidthVectors(Range range) {
        BaseLargeVariableWidthVector leftVector = (BaseLargeVariableWidthVector)this.left;
        BaseLargeVariableWidthVector rightVector = (BaseLargeVariableWidthVector)this.right;
        for (int i = 0; i < range.getLength(); ++i) {
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            int offsetWidth = 8;
            if (isNull) continue;
            long startIndexLeft = leftVector.getOffsetBuffer().getLong((long)leftIndex * (long)offsetWidth);
            long endIndexLeft = leftVector.getOffsetBuffer().getLong((long)(leftIndex + 1) * (long)offsetWidth);
            long startIndexRight = rightVector.getOffsetBuffer().getLong((long)rightIndex * (long)offsetWidth);
            long endIndexRight = rightVector.getOffsetBuffer().getLong((long)(rightIndex + 1) * (long)offsetWidth);
            int ret = ByteFunctionHelpers.equal(leftVector.getDataBuffer(), startIndexLeft, endIndexLeft, rightVector.getDataBuffer(), startIndexRight, endIndexRight);
            if (ret != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean compareBaseVariableWidthViewVectors(Range range) {
        BaseVariableWidthViewVector leftVector = (BaseVariableWidthViewVector)this.left;
        BaseVariableWidthViewVector rightVector = (BaseVariableWidthViewVector)this.right;
        ArrowBuf leftViewBuffer = leftVector.getDataBuffer();
        ArrowBuf rightViewBuffer = rightVector.getDataBuffer();
        int elementSize = 16;
        int lengthWidth = 4;
        int prefixWidth = 4;
        int bufIndexWidth = 4;
        List<ArrowBuf> leftDataBuffers = leftVector.getDataBuffers();
        List<ArrowBuf> rightDataBuffers = rightVector.getDataBuffers();
        for (int i = 0; i < range.getLength(); ++i) {
            int rightDataBufferValueLength;
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            if (isNull) continue;
            int startLeftByteOffset = leftIndex * 16;
            int startRightByteOffset = rightIndex * 16;
            int leftDataBufferValueLength = leftVector.getValueLength(leftIndex);
            if (leftDataBufferValueLength != (rightDataBufferValueLength = rightVector.getValueLength(rightIndex))) {
                return false;
            }
            if (leftDataBufferValueLength > 12) {
                ArrowBuf rightDataBuffer;
                int leftDataBufferIndex = leftViewBuffer.getInt(startLeftByteOffset + 4 + 4);
                int rightDataBufferIndex = rightViewBuffer.getInt(startRightByteOffset + 4 + 4);
                int leftDataOffset = leftViewBuffer.getInt(startLeftByteOffset + 4 + 4 + 4);
                int rightDataOffset = rightViewBuffer.getInt(startRightByteOffset + 4 + 4 + 4);
                ArrowBuf leftDataBuffer = leftDataBuffers.get(leftDataBufferIndex);
                int retDataBuf = ByteFunctionHelpers.equal(leftDataBuffer, leftDataOffset, leftDataOffset + leftDataBufferValueLength, rightDataBuffer = rightDataBuffers.get(rightDataBufferIndex), rightDataOffset, rightDataOffset + rightDataBufferValueLength);
                if (retDataBuf != 0) continue;
                return false;
            }
            int leftDataOffset = startLeftByteOffset + 4;
            int rightDataOffset = startRightByteOffset + 4;
            int retDataBuf = ByteFunctionHelpers.equal(leftViewBuffer, leftDataOffset, leftDataOffset + leftDataBufferValueLength, rightViewBuffer, rightDataOffset, rightDataOffset + rightDataBufferValueLength);
            if (retDataBuf != 0) continue;
            return false;
        }
        return true;
    }

    protected boolean compareListVectors(Range range) {
        ListVector leftVector = (ListVector)this.left;
        ListVector rightVector = (ListVector)this.right;
        RangeEqualsVisitor innerVisitor = this.createInnerVisitor(leftVector.getDataVector(), rightVector.getDataVector(), null);
        Range innerRange = new Range();
        for (int i = 0; i < range.getLength(); ++i) {
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            int offsetWidth = 4;
            if (isNull) continue;
            int startIndexLeft = leftVector.getOffsetBuffer().getInt(leftIndex * offsetWidth);
            int endIndexLeft = leftVector.getOffsetBuffer().getInt((leftIndex + 1) * offsetWidth);
            int startIndexRight = rightVector.getOffsetBuffer().getInt(rightIndex * offsetWidth);
            int endIndexRight = rightVector.getOffsetBuffer().getInt((rightIndex + 1) * offsetWidth);
            if (endIndexLeft - startIndexLeft != endIndexRight - startIndexRight) {
                return false;
            }
            if (innerVisitor.rangeEquals(innerRange = innerRange.setRightStart(startIndexRight).setLeftStart(startIndexLeft).setLength(endIndexLeft - startIndexLeft))) continue;
            return false;
        }
        return true;
    }

    protected boolean compareFixedSizeListVectors(Range range) {
        FixedSizeListVector leftVector = (FixedSizeListVector)this.left;
        FixedSizeListVector rightVector = (FixedSizeListVector)this.right;
        if (leftVector.getListSize() != rightVector.getListSize()) {
            return false;
        }
        int listSize = leftVector.getListSize();
        RangeEqualsVisitor innerVisitor = this.createInnerVisitor(leftVector.getDataVector(), rightVector.getDataVector(), null);
        Range innerRange = new Range(0, 0, listSize);
        for (int i = 0; i < range.getLength(); ++i) {
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            if (isNull) continue;
            int endIndexLeft = (leftIndex + 1) * listSize;
            int startIndexLeft = leftIndex * listSize;
            int endIndexRight = (rightIndex + 1) * listSize;
            int startIndexRight = rightIndex * listSize;
            if (endIndexLeft - startIndexLeft != endIndexRight - startIndexRight) {
                return false;
            }
            if (innerVisitor.rangeEquals(innerRange = innerRange.setLeftStart(startIndexLeft).setRightStart(startIndexRight))) continue;
            return false;
        }
        return true;
    }

    protected boolean compareLargeListVectors(Range range) {
        LargeListVector leftVector = (LargeListVector)this.left;
        LargeListVector rightVector = (LargeListVector)this.right;
        RangeEqualsVisitor innerVisitor = this.createInnerVisitor(leftVector.getDataVector(), rightVector.getDataVector(), null);
        Range innerRange = new Range();
        for (int i = 0; i < range.getLength(); ++i) {
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            long offsetWidth = 8L;
            if (isNull) continue;
            long startIndexLeft = leftVector.getOffsetBuffer().getLong((long)leftIndex * offsetWidth);
            long endIndexLeft = leftVector.getOffsetBuffer().getLong((long)(leftIndex + 1) * offsetWidth);
            long startIndexRight = rightVector.getOffsetBuffer().getLong((long)rightIndex * offsetWidth);
            long endIndexRight = rightVector.getOffsetBuffer().getLong((long)(rightIndex + 1) * offsetWidth);
            if (endIndexLeft - startIndexLeft != endIndexRight - startIndexRight) {
                return false;
            }
            if (innerVisitor.rangeEquals(innerRange = innerRange.setRightStart(LargeMemoryUtil.checkedCastToInt(startIndexRight)).setLeftStart(LargeMemoryUtil.checkedCastToInt(startIndexLeft)).setLength(LargeMemoryUtil.checkedCastToInt(endIndexLeft - startIndexLeft)))) continue;
            return false;
        }
        return true;
    }

    protected boolean compareListViewVectors(Range range) {
        ListViewVector leftVector = (ListViewVector)this.left;
        ListViewVector rightVector = (ListViewVector)this.right;
        RangeEqualsVisitor innerVisitor = this.createInnerVisitor(leftVector.getDataVector(), rightVector.getDataVector(), null);
        Range innerRange = new Range();
        for (int i = 0; i < range.getLength(); ++i) {
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            int offsetWidth = 4;
            int sizeWidth = 4;
            if (isNull) continue;
            int startIndexLeft = leftVector.getOffsetBuffer().getInt((long)leftIndex * (long)offsetWidth);
            int leftSize = leftVector.getSizeBuffer().getInt((long)leftIndex * (long)sizeWidth);
            int startIndexRight = rightVector.getOffsetBuffer().getInt((long)rightIndex * (long)offsetWidth);
            int rightSize = rightVector.getSizeBuffer().getInt((long)rightIndex * (long)sizeWidth);
            if (leftSize != rightSize) {
                return false;
            }
            if (innerVisitor.rangeEquals(innerRange = innerRange.setRightStart(startIndexRight).setLeftStart(startIndexLeft).setLength(leftSize))) continue;
            return false;
        }
        return true;
    }

    protected boolean compareLargeListViewVectors(Range range) {
        LargeListViewVector leftVector = (LargeListViewVector)this.left;
        LargeListViewVector rightVector = (LargeListViewVector)this.right;
        RangeEqualsVisitor innerVisitor = this.createInnerVisitor(leftVector.getDataVector(), rightVector.getDataVector(), null);
        Range innerRange = new Range();
        for (int i = 0; i < range.getLength(); ++i) {
            int leftIndex = range.getLeftStart() + i;
            int rightIndex = range.getRightStart() + i;
            boolean isNull = leftVector.isNull(leftIndex);
            if (isNull != rightVector.isNull(rightIndex)) {
                return false;
            }
            int offsetWidth = 8;
            int sizeWidth = 8;
            if (isNull) continue;
            int startIndexLeft = leftVector.getOffsetBuffer().getInt((long)leftIndex * (long)offsetWidth);
            int leftSize = leftVector.getSizeBuffer().getInt((long)leftIndex * (long)sizeWidth);
            int startIndexRight = rightVector.getOffsetBuffer().getInt((long)rightIndex * (long)offsetWidth);
            int rightSize = rightVector.getSizeBuffer().getInt((long)rightIndex * (long)sizeWidth);
            if (leftSize != rightSize) {
                return false;
            }
            if (innerVisitor.rangeEquals(innerRange = innerRange.setRightStart(startIndexRight).setLeftStart(startIndexLeft).setLength(leftSize))) continue;
            return false;
        }
        return true;
    }
}

