/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.complex;

import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.CommonUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.util.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.AddOrGetResult;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseVariableWidthVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DensityAwareVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.NullVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt4Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ZeroVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.RepeatedValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.CallBack;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.OversizedAllocationException;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.SchemaChangeRuntimeException;
import java.util.Collections;
import java.util.Iterator;

public abstract class BaseLargeRepeatedValueViewVector
extends BaseValueVector
implements RepeatedValueVector,
FieldVector {
    public static final FieldVector DEFAULT_DATA_VECTOR = ZeroVector.INSTANCE;
    public static final String DATA_VECTOR_NAME = "$data$";
    public static final byte OFFSET_WIDTH = 8;
    public static final byte SIZE_WIDTH = 8;
    protected ArrowBuf offsetBuffer;
    protected ArrowBuf sizeBuffer;
    protected FieldVector vector;
    protected final CallBack repeatedCallBack;
    protected int valueCount;
    protected long offsetAllocationSizeInBytes = 31760L;
    protected long sizeAllocationSizeInBytes = 31760L;
    private final String name;
    protected String defaultDataVectorName = "$data$";

    protected BaseLargeRepeatedValueViewVector(String name, BufferAllocator allocator, CallBack callBack) {
        this(name, allocator, DEFAULT_DATA_VECTOR, callBack);
    }

    protected BaseLargeRepeatedValueViewVector(String name, BufferAllocator allocator, FieldVector vector, CallBack callBack) {
        super(allocator);
        this.name = name;
        this.offsetBuffer = allocator.getEmpty();
        this.sizeBuffer = allocator.getEmpty();
        this.vector = Preconditions.checkNotNull(vector, "data vector cannot be null");
        this.repeatedCallBack = callBack;
        this.valueCount = 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean dataAlloc = false;
        try {
            this.allocateBuffers();
            dataAlloc = this.vector.allocateNewSafe();
        }
        catch (Exception e) {
            this.clear();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!dataAlloc) {
                this.clear();
            }
        }
        return dataAlloc;
    }

    private void allocateBuffers() {
        this.offsetBuffer = this.allocateBuffers(this.offsetAllocationSizeInBytes);
        this.sizeBuffer = this.allocateBuffers(this.sizeAllocationSizeInBytes);
    }

    protected ArrowBuf allocateBuffers(long size) {
        int curSize = (int)size;
        ArrowBuf buffer = this.allocator.buffer(curSize);
        buffer.readerIndex(0L);
        buffer.setZero(0L, buffer.capacity());
        return buffer;
    }

    @Override
    public void reAlloc() {
        this.reallocateBuffers();
        this.vector.reAlloc();
    }

    protected void reallocateBuffers() {
        this.reallocOffsetBuffer();
        this.reallocSizeBuffer();
    }

    private void reallocOffsetBuffer() {
        long currentBufferCapacity = this.offsetBuffer.capacity();
        long newAllocationSize = currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.offsetAllocationSizeInBytes > 0L ? this.offsetAllocationSizeInBytes : 63520L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        newAllocationSize = Math.min(newAllocationSize, 0x3FFFFFFF8L);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > MAX_ALLOCATION_SIZE || newAllocationSize <= this.offsetBuffer.capacity()) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.offsetBuffer, 0L, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.offsetBuffer.getReferenceManager().release(1);
        this.offsetBuffer = newBuf;
        this.offsetAllocationSizeInBytes = newAllocationSize;
    }

    private void reallocSizeBuffer() {
        long currentBufferCapacity = this.sizeBuffer.capacity();
        long newAllocationSize = currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.sizeAllocationSizeInBytes > 0L ? this.sizeAllocationSizeInBytes : 63520L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        newAllocationSize = Math.min(newAllocationSize, 0x3FFFFFFF8L);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > MAX_ALLOCATION_SIZE || newAllocationSize <= this.sizeBuffer.capacity()) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.sizeBuffer, 0L, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.sizeBuffer.getReferenceManager().release(1);
        this.sizeBuffer = newBuf;
        this.sizeAllocationSizeInBytes = newAllocationSize;
    }

    @Override
    public FieldVector getDataVector() {
        return this.vector;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.offsetAllocationSizeInBytes = (long)numRecords * 8L;
        this.sizeAllocationSizeInBytes = (long)numRecords * 8L;
        if (this.vector instanceof BaseFixedWidthVector || this.vector instanceof BaseVariableWidthVector) {
            this.vector.setInitialCapacity(numRecords * 5);
        } else {
            this.vector.setInitialCapacity(numRecords);
        }
    }

    @Override
    public void setInitialCapacity(int numRecords, double density) {
        if ((double)numRecords * density >= 2.147483647E9) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed");
        }
        this.offsetAllocationSizeInBytes = (long)numRecords * 8L;
        this.sizeAllocationSizeInBytes = (long)numRecords * 8L;
        int innerValueCapacity = Math.max((int)((double)numRecords * density), 1);
        if (this.vector instanceof DensityAwareVector) {
            ((DensityAwareVector)((Object)this.vector)).setInitialCapacity(innerValueCapacity, density);
        } else {
            this.vector.setInitialCapacity(innerValueCapacity);
        }
    }

    public void setInitialTotalCapacity(int numRecords, int totalNumberOfElements) {
        this.offsetAllocationSizeInBytes = (long)numRecords * 8L;
        this.sizeAllocationSizeInBytes = (long)numRecords * 8L;
        this.vector.setInitialCapacity(totalNumberOfElements);
    }

    @Override
    public int getValueCapacity() {
        throw new UnsupportedOperationException("Get value capacity is not supported in RepeatedValueVector");
    }

    protected int getOffsetBufferValueCapacity() {
        return LargeMemoryUtil.checkedCastToInt(this.offsetBuffer.capacity() / 8L);
    }

    protected int getSizeBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.sizeBuffer.capacity() / 8L);
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 8 + this.valueCount * 8 + this.vector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int innerVectorValueCount = 0;
        for (int i = 0; i < valueCount; ++i) {
            innerVectorValueCount += this.sizeBuffer.getInt(i * 8);
        }
        return valueCount * 8 + valueCount * 8 + this.vector.getBufferSizeFor(LargeMemoryUtil.checkedCastToInt(innerVectorValueCount));
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.singleton(this.getDataVector()).iterator();
    }

    @Override
    public void clear() {
        this.offsetBuffer = this.releaseBuffer(this.offsetBuffer);
        this.sizeBuffer = this.releaseBuffer(this.sizeBuffer);
        this.vector.clear();
        this.valueCount = 0;
        super.clear();
    }

    @Override
    public void reset() {
        this.offsetBuffer.setZero(0L, this.offsetBuffer.capacity());
        this.sizeBuffer.setZero(0L, this.sizeBuffer.capacity());
        this.vector.reset();
        this.valueCount = 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        return new ArrowBuf[0];
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        while (valueCount > this.getOffsetBufferValueCapacity()) {
            this.reallocateBuffers();
        }
        int childValueCount = valueCount == 0 ? 0 : this.getMaxViewEndChildVector();
        this.vector.setValueCount(childValueCount);
    }

    protected int getMaxViewEndChildVector() {
        int maxOffsetSizeSum = this.offsetBuffer.getInt(0L) + this.sizeBuffer.getInt(0L);
        for (int i = 0; i < this.valueCount; ++i) {
            int currentOffset = this.offsetBuffer.getInt((long)i * 8L);
            int currentSize = this.sizeBuffer.getInt((long)i * 8L);
            int currentSum = currentOffset + currentSize;
            maxOffsetSizeSum = Math.max(maxOffsetSizeSum, currentSum);
        }
        return maxOffsetSizeSum;
    }

    protected int getMaxViewEndChildVectorByIndex(int index) {
        int maxOffsetSizeSum = this.offsetBuffer.getInt(0L) + this.sizeBuffer.getInt(0L);
        for (int i = 0; i < index; ++i) {
            int currentOffset = this.offsetBuffer.getInt((long)i * 8L);
            int currentSize = this.sizeBuffer.getInt((long)i * 8L);
            int currentSum = currentOffset + currentSize;
            maxOffsetSizeSum = Math.max(maxOffsetSizeSum, currentSum);
        }
        return maxOffsetSizeSum;
    }

    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType fieldType) {
        boolean created = false;
        if (this.vector instanceof NullVector) {
            this.vector = fieldType.createNewSingleVector(this.defaultDataVectorName, this.allocator, this.repeatedCallBack);
            created = true;
            if (this.repeatedCallBack != null && fieldType.getType().getTypeID() != ArrowType.ArrowTypeID.Null) {
                this.repeatedCallBack.doWork();
            }
        }
        if (this.vector.getField().getType().getTypeID() != fieldType.getType().getTypeID()) {
            String msg = String.format("Inner vector type mismatch. Requested type: [%s], actual type: [%s]", new Object[]{fieldType.getType().getTypeID(), this.vector.getField().getType().getTypeID()});
            throw new SchemaChangeRuntimeException(msg);
        }
        return new AddOrGetResult<FieldVector>(this.vector, created);
    }

    protected void replaceDataVector(FieldVector v) {
        this.vector.clear();
        this.vector = v;
    }

    public abstract boolean isEmpty(int var1);

    public int startNewValue(int index) {
        while (index >= this.getOffsetBufferValueCapacity()) {
            this.reallocOffsetBuffer();
        }
        while (index >= this.getSizeBufferValueCapacity()) {
            this.reallocSizeBuffer();
        }
        if (index > 0) {
            int prevOffset = this.getMaxViewEndChildVectorByIndex(index);
            this.offsetBuffer.setInt((long)index * 8L, prevOffset);
        }
        this.setValueCount(index + 1);
        return this.offsetBuffer.getInt((long)index * 8L);
    }

    @Override
    @Deprecated
    public UInt4Vector getOffsetVector() {
        throw new UnsupportedOperationException("There is no inner offset vector");
    }
}

