/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.complex;

import com.dremio.jdbc.shaded.com.dremio.common.expression.AbstractArrowTypeVisitor;
import com.dremio.jdbc.shaded.com.dremio.common.expression.BasePath;
import com.dremio.jdbc.shaded.com.dremio.common.expression.CompleteType;
import com.dremio.jdbc.shaded.com.dremio.common.expression.PathSegment;
import com.dremio.jdbc.shaded.com.dremio.exec.record.BatchSchema;
import com.dremio.jdbc.shaded.com.dremio.exec.record.TypedFieldId;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;

public final class FieldIdUtil2 {
    private static final Logger logger = LoggerFactory.getLogger(FieldIdUtil2.class);

    private static TypedFieldId getFieldIdIfMatchesUnion(Field field, TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        if (seg == null) {
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(field));
            }
            return builder.finalType(CompleteType.fromField(field)).build();
        }
        PathSegment.PathSegmentType segType = seg.getType();
        if (segType.equals((Object)PathSegment.PathSegmentType.NAME)) {
            FieldWithOrdinal ford = FieldIdUtil2.getChildField(field, "struct");
            if (ford != null) {
                return FieldIdUtil2.getFieldIdIfMatches(ford.field, builder, addToBreadCrumb, seg);
            }
            return null;
        }
        if (segType.equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX) || segType.equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX_REF)) {
            FieldWithOrdinal ford = FieldIdUtil2.getChildField(field, "list");
            if (ford != null) {
                return FieldIdUtil2.getFieldIdIfMatches(ford.field, builder, addToBreadCrumb, seg);
            }
            return null;
        }
        return null;
    }

    public static TypedFieldId getFieldId(BatchSchema schema, BasePath path) {
        PathSegment.ArraySegmentInputRef arraySegmentInputRef;
        TypedFieldId inputRefField;
        boolean isHyper;
        boolean bl = isHyper = schema.getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE;
        if (path.getRootSegment().getPathSegment().getChild() instanceof PathSegment.ArraySegmentInputRef && (inputRefField = FieldIdUtil2.getFieldIdForArrayInputRef(schema, arraySegmentInputRef = (PathSegment.ArraySegmentInputRef)path.getRootSegment().getPathSegment().getChild(), isHyper)) != null) {
            arraySegmentInputRef.setFieldId(inputRefField);
        }
        return FieldIdUtil2.getFieldId(schema, path, isHyper);
    }

    public static TypedFieldId getFieldIdForArrayInputRef(Schema schema, PathSegment.ArraySegmentInputRef path, boolean isHyper) {
        int i = 0;
        for (Field f : schema.getFields()) {
            TypedFieldId id = FieldIdUtil2.getFieldIdForArrayInputRef(f, i, path, isHyper);
            if (id != null) {
                return id;
            }
            ++i;
        }
        return null;
    }

    public static TypedFieldId getFieldIdForArrayInputRef(Field field, int id, PathSegment.ArraySegmentInputRef seg, boolean isHyper) {
        if (!seg.getPath().equalsIgnoreCase(field.getName())) {
            return null;
        }
        TypedFieldId.Builder builder = TypedFieldId.newBuilder();
        if (isHyper) {
            builder.hyper();
        }
        return field.getType().accept(new FieldVisitor(field, id, seg, builder));
    }

    public static TypedFieldId getFieldId(Schema schema, BasePath path, boolean isHyper) {
        int i = 0;
        for (Field f : schema.getFields()) {
            TypedFieldId id = FieldIdUtil2.getFieldId(f, i, path, isHyper);
            if (id != null) {
                return id;
            }
            ++i;
        }
        return null;
    }

    public static TypedFieldId getFieldId(Field field, int id, BasePath expectedPath, boolean isHyper) {
        if (!expectedPath.getRootSegment().getNameSegment().getPath().equalsIgnoreCase(field.getName())) {
            return null;
        }
        PathSegment.NameSegment seg = expectedPath.getRootSegment();
        TypedFieldId.Builder builder = TypedFieldId.newBuilder();
        if (isHyper) {
            builder.hyper();
        }
        return field.getType().accept(new FieldVisitor(field, id, seg, builder));
    }

    private static TypedFieldId getFieldIdIfMatches(Field field, TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        Field inner;
        if (seg == null) {
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(field));
            }
            return builder.finalType(CompleteType.fromField(field)).build();
        }
        ArrowType.ArrowTypeID typeType = field.getType().getTypeID();
        PathSegment.PathSegmentType segType = seg.getType();
        if (segType.equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX) || segType.equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX_REF)) {
            builder.isListOrUnionInPath(true);
            if (seg.isLastPath()) {
                CompleteType type;
                if (typeType == ArrowType.ArrowTypeID.Struct) {
                    type = CompleteType.fromField(field);
                } else if (typeType == ArrowType.ArrowTypeID.List) {
                    type = CompleteType.fromField(field.getChildren().get(0));
                    builder.isListOrUnionInPath(true);
                    builder.listVector();
                } else {
                    throw new UnsupportedOperationException("FieldIdUtil does not support field of type " + String.valueOf(field.getType()));
                }
                builder.withIndex().finalType(type);
                if (addToBreadCrumb) {
                    addToBreadCrumb = false;
                    builder.remainder(seg);
                }
                return builder.build();
            }
            if (addToBreadCrumb) {
                addToBreadCrumb = false;
                builder.remainder(seg);
            }
        } else if (typeType == ArrowType.ArrowTypeID.List) {
            builder.isListOrUnionInPath(true);
            return null;
        }
        if (typeType == ArrowType.ArrowTypeID.Struct) {
            if (segType.equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX)) {
                builder.isListOrUnionInPath(true);
                return null;
            }
            FieldWithOrdinal ford = FieldIdUtil2.getChildField(field, segType.equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX) ? null : seg.getNameSegment().getPath());
            if (ford == null) {
                return null;
            }
            inner = ford.field;
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(inner));
                builder.addId(ford.ordinal);
            }
        } else if (typeType == ArrowType.ArrowTypeID.List) {
            builder.isListOrUnionInPath(true);
            inner = field.getChildren().get(0);
        } else {
            throw new UnsupportedOperationException("FieldIdUtil does not support field of type " + String.valueOf(field.getType()));
        }
        ArrowType.ArrowTypeID innerTypeType = inner.getType().getTypeID();
        if (innerTypeType == ArrowType.ArrowTypeID.List || innerTypeType == ArrowType.ArrowTypeID.Struct) {
            if (innerTypeType == ArrowType.ArrowTypeID.List) {
                builder.isListOrUnionInPath(true);
            }
            return FieldIdUtil2.getFieldIdIfMatches(inner, builder, addToBreadCrumb, seg.getChild());
        }
        if (innerTypeType == ArrowType.ArrowTypeID.Union) {
            builder.isListOrUnionInPath(true);
            return FieldIdUtil2.getFieldIdIfMatchesUnion(inner, builder, addToBreadCrumb, seg.getChild());
        }
        if (seg.getType().equals((Object)PathSegment.PathSegmentType.NAME)) {
            if (addToBreadCrumb) {
                builder.intermediateType(CompleteType.fromField(inner));
            }
            builder.finalType(CompleteType.fromField(inner));
        } else {
            builder.finalType(CompleteType.fromField(inner));
        }
        if (seg.isLastPath()) {
            return builder.build();
        }
        PathSegment child = seg.getChild();
        if (child.isLastPath() && child.getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX)) {
            builder.isListOrUnionInPath(true);
            if (addToBreadCrumb) {
                builder.remainder(child);
            }
            builder.finalType(CompleteType.fromField(inner));
            return builder.build();
        }
        logger.warn("You tried to request a complex type inside a scalar object or path or type is wrong.");
        return null;
    }

    private static FieldWithOrdinal getChildField(Field f, String name) {
        HashMap<String, FieldWithOrdinal> children = new HashMap<String, FieldWithOrdinal>();
        int i = 0;
        for (Field child : f.getChildren()) {
            children.put(child.getName().toLowerCase(), new FieldWithOrdinal(child, i));
            ++i;
        }
        return (FieldWithOrdinal)children.get(name.toLowerCase());
    }

    private FieldIdUtil2() {
    }

    private static class FieldWithOrdinal {
        private final Field field;
        private final int ordinal;

        public FieldWithOrdinal(Field field, int ordinal) {
            this.field = field;
            this.ordinal = ordinal;
        }
    }

    private static class FieldVisitor
    extends AbstractArrowTypeVisitor<TypedFieldId> {
        private final Field field;
        private final int id;
        private final PathSegment seg;
        private final TypedFieldId.Builder builder;

        public FieldVisitor(Field field, int id, PathSegment seg, TypedFieldId.Builder builder) {
            this.field = field;
            this.id = id;
            this.seg = seg;
            this.builder = builder;
        }

        @Override
        public TypedFieldId visit(ArrowType.Struct incoming) {
            this.builder.intermediateType(CompleteType.fromField(this.field));
            this.builder.addId(this.id);
            return FieldIdUtil2.getFieldIdIfMatches(this.field, this.builder, true, this.seg.getChild());
        }

        @Override
        public TypedFieldId visit(ArrowType.List incoming) {
            this.builder.intermediateType(CompleteType.fromField(this.field));
            this.builder.addId(this.id);
            this.builder.isListOrUnionInPath(true);
            return FieldIdUtil2.getFieldIdIfMatches(this.field, this.builder, true, this.seg.getChild());
        }

        @Override
        public TypedFieldId visit(ArrowType.Union incoming) {
            this.builder.addId(this.id).remainder(this.seg.getChild());
            this.builder.isListOrUnionInPath(true);
            CompleteType type = CompleteType.fromField(this.field);
            this.builder.intermediateType(type);
            if (this.seg.isLastPath()) {
                this.builder.finalType(type);
                return this.builder.build();
            }
            return FieldIdUtil2.getFieldIdIfMatchesUnion(this.field, this.builder, false, this.seg.getChild());
        }

        @Override
        protected TypedFieldId visitGeneric(ArrowType type) {
            this.builder.intermediateType(CompleteType.fromField(this.field));
            this.builder.addId(this.id);
            this.builder.finalType(CompleteType.fromField(this.field));
            if (this.seg.isLastPath()) {
                return this.builder.build();
            }
            PathSegment child = this.seg.getChild();
            if (child.getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX) && child.isLastPath()) {
                this.builder.remainder(child);
                this.builder.withIndex();
                this.builder.finalType(CompleteType.fromField(this.field));
                return this.builder.build();
            }
            return null;
        }
    }
}

