/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.complex;

import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.OutOfMemoryException;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.ByteFunctionHelpers;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.CommonUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import com.dremio.jdbc.shaded.org.apache.arrow.util.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.AddOrGetResult;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BaseValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BitVectorHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BufferBacked;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueIterableVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ZeroVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compare.VectorVisitor;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.BaseRepeatedValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.PromotableVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.UnionVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.impl.ComplexCopier;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.impl.UnionListReader;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.impl.UnionListWriter;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.CallBack;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.JsonStringArrayList;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.OversizedAllocationException;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.TransferPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListVector
extends BaseRepeatedValueVector
implements PromotableVector,
ValueIterableVector<List<?>> {
    protected ArrowBuf validityBuffer;
    protected UnionListReader reader;
    private CallBack callBack;
    protected Field field;
    protected int validityAllocationSizeInBytes;
    protected int lastSet;

    public static ListVector empty(String name, BufferAllocator allocator) {
        return new ListVector(name, allocator, FieldType.nullable(ArrowType.List.INSTANCE), null);
    }

    public ListVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        this(new Field(name, fieldType, null), allocator, callBack);
    }

    public ListVector(Field field, BufferAllocator allocator, CallBack callBack) {
        super(field.getName(), allocator, callBack);
        this.validityBuffer = allocator.getEmpty();
        this.field = field;
        this.callBack = callBack;
        this.validityAllocationSizeInBytes = ListVector.getValidityBufferSizeFromCount(3970);
        this.lastSet = -1;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        Preconditions.checkArgument(children.size() == 1, "Lists have one child Field. Found: %s", children.isEmpty() ? "none" : children);
        Field field = children.get(0);
        AddOrGetResult addOrGetVector = this.addOrGetVector(field.getFieldType());
        Preconditions.checkArgument(addOrGetVector.isCreated(), "Child vector already existed: %s", addOrGetVector.getVector());
        ((FieldVector)addOrGetVector.getVector()).initializeChildrenFromFields(field.getChildren());
        this.field = new Field(this.field.getName(), this.field.getFieldType(), children);
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.validityAllocationSizeInBytes = ListVector.getValidityBufferSizeFromCount(numRecords);
        super.setInitialCapacity(numRecords);
    }

    @Override
    public void setInitialCapacity(int numRecords, double density) {
        this.validityAllocationSizeInBytes = ListVector.getValidityBufferSizeFromCount(numRecords);
        super.setInitialCapacity(numRecords, density);
    }

    @Override
    public void setInitialTotalCapacity(int numRecords, int totalNumberOfElements) {
        this.validityAllocationSizeInBytes = ListVector.getValidityBufferSizeFromCount(numRecords);
        super.setInitialTotalCapacity(numRecords, totalNumberOfElements);
    }

    public double getDensity() {
        if (this.valueCount == 0) {
            return 0.0;
        }
        int startOffset = this.offsetBuffer.getInt(0L);
        int endOffset = this.offsetBuffer.getInt(this.valueCount * 4);
        double totalListSize = endOffset - startOffset;
        return totalListSize / (double)this.valueCount;
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.singletonList(this.getDataVector());
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 2) {
            throw new IllegalArgumentException("Illegal buffer count, expected 2, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        ArrowBuf offBuffer = ownBuffers.get(1);
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.offsetBuffer.getReferenceManager().release();
        this.offsetBuffer = offBuffer.getReferenceManager().retain(offBuffer, this.allocator);
        this.validityAllocationSizeInBytes = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
        this.offsetAllocationSizeInBytes = this.offsetBuffer.capacity();
        this.lastSet = fieldNode.getLength() - 1;
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(2);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.offsetBuffer);
        return result;
    }

    @Override
    public void exportCDataBuffers(List<ArrowBuf> buffers, ArrowBuf buffersPtr, long nullValue) {
        this.exportBuffer(this.validityBuffer, buffers, buffersPtr, nullValue, true);
        if (this.offsetBuffer.capacity() == 0L) {
            this.exportBuffer(this.allocateOffsetBuffer(4L), buffers, buffersPtr, nullValue, false);
        } else {
            this.exportBuffer(this.offsetBuffer, buffers, buffersPtr, nullValue, true);
        }
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0L);
        this.offsetBuffer.readerIndex(0L);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0L);
            this.offsetBuffer.writerIndex(0L);
        } else {
            this.validityBuffer.writerIndex(ListVector.getValidityBufferSizeFromCount(this.valueCount));
            this.offsetBuffer.writerIndex((this.valueCount + 1) * 4);
        }
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    public UnionListWriter getWriter() {
        return new UnionListWriter(this);
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            this.clear();
            this.allocateValidityBuffer(this.validityAllocationSizeInBytes);
            success = super.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        return success;
    }

    protected void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0L);
        this.validityAllocationSizeInBytes = curSize;
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.reallocValidityBuffer();
        super.reAlloc();
    }

    protected void reallocValidityAndOffsetBuffers() {
        this.reallocOffsetBuffer();
        this.reallocValidityBuffer();
    }

    private void reallocValidityBuffer() {
        int currentBufferCapacity = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
        long newAllocationSize = this.getNewAllocationSize(currentBufferCapacity);
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.validityBuffer, 0L, (long)currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - (long)currentBufferCapacity);
        this.validityBuffer.getReferenceManager().release(1);
        this.validityBuffer = newBuf;
        this.validityAllocationSizeInBytes = (int)newAllocationSize;
    }

    private long getNewAllocationSize(int currentBufferCapacity) {
        long newAllocationSize = (long)currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.validityAllocationSizeInBytes > 0 ? (long)this.validityAllocationSizeInBytes : (long)ListVector.getValidityBufferSizeFromCount(3970) * 2L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        return newAllocationSize;
    }

    @Override
    public void copyFromSafe(int inIndex, int outIndex, ValueVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    @Override
    public void copyFrom(int inIndex, int outIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        FieldReader in = from.getReader();
        in.setPosition(inIndex);
        UnionListWriter out = this.getWriter();
        out.setPosition(outIndex);
        ComplexCopier.copy(in, out);
    }

    @Override
    public FieldVector getDataVector() {
        return this.vector;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return this.getTransferPair(field, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(field, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((ListVector)target);
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        return this.offsetBuffer.memoryAddress();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        return this.offsetBuffer;
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        if (this.isSet(index) == 0) {
            return 0;
        }
        int hash = 0;
        int start = this.offsetBuffer.getInt(index * 4);
        int end = this.offsetBuffer.getInt((index + 1) * 4);
        for (int i = start; i < end; ++i) {
            hash = ByteFunctionHelpers.combineHash(hash, this.vector.hashCode(i, hasher));
        }
        return hash;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new UnionListReader(this);
    }

    @Override
    public UnionListReader getReader() {
        this.reader = (UnionListReader)super.getReader();
        return this.reader;
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType fieldType) {
        AddOrGetResult result = super.addOrGetVector(fieldType);
        this.invalidateReader();
        return result;
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        int offsetBufferSize = (this.valueCount + 1) * 4;
        int validityBufferSize = ListVector.getValidityBufferSizeFromCount(this.valueCount);
        return offsetBufferSize + validityBufferSize + this.vector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int validityBufferSize = ListVector.getValidityBufferSizeFromCount(valueCount);
        return super.getBufferSizeFor(valueCount) + validityBufferSize;
    }

    @Override
    public Field getField() {
        if (this.field.getChildren().contains(this.getDataVector().getField())) {
            return this.field;
        }
        this.field = new Field(this.field.getName(), this.field.getFieldType(), Collections.singletonList(this.getDataVector().getField()));
        return this.field;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LIST;
    }

    @Override
    public void clear() {
        super.clear();
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.lastSet = -1;
    }

    @Override
    public void reset() {
        super.reset();
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
        this.lastSet = -1;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.offsetBuffer);
            list.add(this.validityBuffer);
            list.addAll(Arrays.asList(this.vector.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain();
            }
            this.clear();
        }
        return buffers;
    }

    @Override
    public UnionVector promoteToUnion() {
        UnionVector vector = new UnionVector("$data$", this.allocator, null, this.callBack);
        this.replaceDataVector(vector);
        this.invalidateReader();
        if (this.callBack != null) {
            this.callBack.doWork();
        }
        return vector;
    }

    protected void invalidateReader() {
        this.fieldReader = null;
        this.reader = null;
    }

    @Override
    public List<?> getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        JsonStringArrayList<Object> vals = new JsonStringArrayList<Object>();
        int start = this.offsetBuffer.getInt(index * 4);
        int end = this.offsetBuffer.getInt((index + 1) * 4);
        FieldVector vv = this.getDataVector();
        for (int i = start; i < end; ++i) {
            vals.add(vv.getObject(i));
        }
        return vals;
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    @Override
    public boolean isEmpty(int index) {
        int end;
        if (this.isNull(index)) {
            return true;
        }
        int start = this.offsetBuffer.getInt(index * 4);
        return start == (end = this.offsetBuffer.getInt((index + 1) * 4));
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public int getValueCapacity() {
        return this.getValidityAndOffsetValueCapacity();
    }

    private int getValidityAndOffsetValueCapacity() {
        int offsetValueCapacity = Math.max(this.getOffsetBufferValueCapacity() - 1, 0);
        return Math.min(offsetValueCapacity, this.getValidityBufferValueCapacity());
    }

    private int getValidityBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.validityBuffer.capacity() * 8L);
    }

    public void setNotNull(int index) {
        while (index >= this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.lastSet = index;
    }

    @Override
    public void setNull(int index) {
        while (index >= this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        if (this.lastSet >= index) {
            this.lastSet = index - 1;
        }
        for (int i = this.lastSet + 1; i <= index; ++i) {
            int currentOffset = this.offsetBuffer.getInt(i * 4);
            this.offsetBuffer.setInt((i + 1) * 4, currentOffset);
        }
        BitVectorHelper.unsetBit(this.validityBuffer, index);
        this.lastSet = index;
    }

    @Override
    public int startNewValue(int index) {
        while (index >= this.getValidityAndOffsetValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        if (this.lastSet >= index) {
            this.lastSet = index - 1;
        }
        for (int i = this.lastSet + 1; i <= index; ++i) {
            int currentOffset = this.offsetBuffer.getInt(i * 4);
            this.offsetBuffer.setInt((i + 1) * 4, currentOffset);
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.lastSet = index;
        return this.offsetBuffer.getInt((this.lastSet + 1) * 4);
    }

    public void endValue(int index, int size) {
        int currentOffset = this.offsetBuffer.getInt((index + 1) * 4);
        this.offsetBuffer.setInt((index + 1) * 4, currentOffset + size);
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        if (valueCount > 0) {
            while (valueCount > this.getValidityAndOffsetValueCapacity()) {
                this.reallocValidityAndOffsetBuffers();
            }
            for (int i = this.lastSet + 1; i < valueCount; ++i) {
                int currentOffset = this.offsetBuffer.getInt(i * 4);
                this.offsetBuffer.setInt((i + 1) * 4, currentOffset);
            }
        }
        int childValueCount = valueCount == 0 ? 0 : this.offsetBuffer.getInt((this.lastSet + 1) * 4);
        this.vector.setValueCount(childValueCount);
    }

    public void setLastSet(int value) {
        this.lastSet = value;
    }

    public int getLastSet() {
        return this.lastSet;
    }

    @Override
    public int getElementStartIndex(int index) {
        return this.offsetBuffer.getInt(index * 4);
    }

    @Override
    public int getElementEndIndex(int index) {
        return this.offsetBuffer.getInt((index + 1) * 4);
    }

    private class TransferImpl
    implements TransferPair {
        ListVector to;
        TransferPair dataTransferPair;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this(new ListVector(name, allocator, listVector.field.getFieldType(), callBack));
        }

        public TransferImpl(Field field, BufferAllocator allocator, CallBack callBack) {
            this(new ListVector(field, allocator, callBack));
        }

        public TransferImpl(ListVector to) {
            this.to = to;
            to.addOrGetVector(ListVector.this.vector.getField().getFieldType());
            if (to.getDataVector() instanceof ZeroVector) {
                to.addOrGetVector(ListVector.this.vector.getField().getFieldType());
            }
            this.dataTransferPair = ListVector.this.getDataVector().makeTransferPair(to.getDataVector());
        }

        @Override
        public void transfer() {
            this.to.clear();
            this.dataTransferPair.transfer();
            this.to.validityBuffer = BaseValueVector.transferBuffer(ListVector.this.validityBuffer, this.to.allocator);
            this.to.offsetBuffer = BaseValueVector.transferBuffer(ListVector.this.offsetBuffer, this.to.allocator);
            this.to.lastSet = ListVector.this.lastSet;
            if (ListVector.this.valueCount > 0) {
                this.to.setValueCount(ListVector.this.valueCount);
            }
            ListVector.this.clear();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= ListVector.this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)ListVector.this.valueCount);
            this.to.clear();
            if (length > 0) {
                int startPoint = ListVector.this.offsetBuffer.getInt(startIndex * 4);
                int sliceLength = ListVector.this.offsetBuffer.getInt((startIndex + length) * 4) - startPoint;
                this.to.offsetBuffer = this.to.allocateOffsetBuffer((length + 1) * 4);
                for (int i = 0; i < length + 1; ++i) {
                    int relativeOffset = ListVector.this.offsetBuffer.getInt((startIndex + i) * 4) - startPoint;
                    this.to.offsetBuffer.setInt(i * 4, relativeOffset);
                }
                this.splitAndTransferValidityBuffer(startIndex, length, this.to);
                this.dataTransferPair.splitAndTransfer(startPoint, sliceLength);
                this.to.lastSet = length - 1;
                this.to.setValueCount(length);
            }
        }

        private void splitAndTransferValidityBuffer(int startIndex, int length, ListVector target) {
            int firstByteSource = BitVectorHelper.byteIndex(startIndex);
            int lastByteSource = BitVectorHelper.byteIndex(ListVector.this.valueCount - 1);
            int byteSizeTarget = ListVector.getValidityBufferSizeFromCount(length);
            int offset = startIndex % 8;
            if (length > 0) {
                if (offset == 0) {
                    if (target.validityBuffer != null) {
                        target.validityBuffer.getReferenceManager().release();
                    }
                    target.validityBuffer = ListVector.this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                    target.validityBuffer.getReferenceManager().retain(1);
                } else {
                    byte b1;
                    target.allocateValidityBuffer(byteSizeTarget);
                    for (int i = 0; i < byteSizeTarget - 1; ++i) {
                        byte b12 = BitVectorHelper.getBitsFromCurrentByte(ListVector.this.validityBuffer, firstByteSource + i, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(ListVector.this.validityBuffer, firstByteSource + i + 1, offset);
                        target.validityBuffer.setByte((long)i, b12 + b2);
                    }
                    if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(ListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(ListVector.this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                        target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
                    } else {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(ListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1);
                    }
                }
            }
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, ListVector.this);
        }
    }
}

