/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.complex;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.exec.expr.TypeHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVectorHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.NonNullableStructVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.StructVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.SerializedFieldHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.BasicTypeHelper;
import java.util.List;

public class NonNullableStructVectorHelper
implements ValueVectorHelper {
    private NonNullableStructVector structVector;

    public NonNullableStructVectorHelper(NonNullableStructVector vector) {
        if (vector instanceof StructVector) {
            throw new IllegalArgumentException("Invalid vector: " + String.valueOf(vector));
        }
        this.structVector = vector;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buf) {
        List<UserBitShared.SerializedField> fields = metadata.getChildList();
        this.structVector.valueCount = metadata.getValueCount();
        int bufOffset = 0;
        for (UserBitShared.SerializedField child : fields) {
            Field fieldDef = SerializedFieldHelper.create(child);
            FieldVector vector = this.structVector.getChild(fieldDef.getName());
            if (vector == null) {
                vector = BasicTypeHelper.getNewVector(fieldDef, this.structVector.allocator);
                this.structVector.putChild(fieldDef.getName(), vector);
            }
            if (child.getValueCount() == 0) {
                vector.clear();
            } else {
                TypeHelper.load(vector, child, buf.slice(bufOffset, child.getBufferLength()));
            }
            bufOffset += child.getBufferLength();
        }
        Preconditions.checkState((long)bufOffset == buf.capacity());
    }

    @Override
    public void materialize(Field field) {
        List<Field> children = field.getChildren();
        for (Field child : children) {
            FieldVector v = TypeHelper.getNewVector(child, this.structVector.allocator, this.structVector.callBack);
            TypeHelper.getHelper(v).ifPresent(t2 -> t2.materialize(child));
            this.structVector.putChild(child.getName(), v);
        }
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder b = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName(this.structVector.getField().getName())).setMajorType(Types.optional(TypeProtos.MinorType.STRUCT)).setBufferLength(this.structVector.getBufferSize()).setValueCount(this.structVector.valueCount);
        for (ValueVector valueVector : this.structVector.getChildren()) {
            b.addChild(TypeHelper.getMetadata(valueVector));
        }
        return b.build();
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return null;
    }

    @Override
    public void loadFromValidityAndDataBuffers(UserBitShared.SerializedField metadata, ArrowBuf dataBuffer, ArrowBuf validityBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadData(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        throw new UnsupportedOperationException();
    }
}

