/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.complex;

import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.types.Types;
import com.dremio.jdbc.shaded.com.dremio.exec.expr.TypeHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVectorHelper;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.NonNullableStructVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.UnionVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;

public class UnionVectorHelper
implements ValueVectorHelper {
    private UnionVector unionVector;

    public UnionVectorHelper(UnionVector vector) {
        this.unionVector = vector;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        this.unionVector.clear();
        this.unionVector.valueCount = metadata.getValueCount();
        int typesLength = metadata.getChild(0).getBufferLength();
        int mapLength = metadata.getChild(1).getBufferLength();
        this.loadTypeBuffer(metadata.getChild(0), buffer);
        TypeHelper.load(this.unionVector.internalStruct, metadata.getChild(1), buffer.slice(typesLength, mapLength));
    }

    private void loadTypeBuffer(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        int valueCount = metadata.getValueCount();
        int actualLength = metadata.getBufferLength();
        int expectedLength = valueCount * 1;
        assert (expectedLength == actualLength) : String.format("Expected to load %d bytes in type buffer but actually loaded %d bytes", expectedLength, actualLength);
        this.unionVector.typeBuffer = buffer.slice(0L, actualLength);
        this.unionVector.typeBuffer.writerIndex(actualLength);
        this.unionVector.typeBuffer.getReferenceManager().retain(1);
    }

    @Override
    public void materialize(Field field) {
        for (Field child : field.getChildren()) {
            FieldVector v = TypeHelper.getNewVector(child, this.unionVector.getAllocator());
            TypeHelper.getHelper(v).ifPresent(t2 -> t2.materialize(child));
            this.unionVector.addVector(v);
        }
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder b = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName(this.unionVector.getField().getName())).setMajorType(Types.optional(TypeProtos.MinorType.UNION)).setBufferLength(this.unionVector.getBufferSize()).setValueCount(this.unionVector.valueCount);
        b.addChild(this.buildTypeField());
        b.addChild(TypeHelper.getMetadata(this.unionVector.internalStruct));
        return b.build();
    }

    private UserBitShared.SerializedField buildTypeField() {
        UserBitShared.SerializedField.Builder typeBuilder = UserBitShared.SerializedField.newBuilder().setNamePart(UserBitShared.NamePart.newBuilder().setName("types").build()).setValueCount(this.unionVector.valueCount).setBufferLength(this.unionVector.valueCount).setMajorType(Types.required(TypeProtos.MinorType.UINT1));
        return typeBuilder.build();
    }

    public NonNullableStructVector getInternalMap() {
        return this.unionVector.internalStruct;
    }

    @Override
    public void loadFromValidityAndDataBuffers(UserBitShared.SerializedField metadata, ArrowBuf dataBuffer, ArrowBuf validityBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void loadData(UserBitShared.SerializedField metadata, ArrowBuf buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserBitShared.SerializedField.Builder getMetadataBuilder() {
        throw new UnsupportedOperationException();
    }
}

