/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.impl;

import com.dremio.jdbc.shaded.org.apache.arrow.memory.util.LargeMemoryUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.LargeListVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.impl.ComplexCopier;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.impl.UnionLargeListWriter;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.UnionHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;

public class UnionLargeListReader
extends AbstractFieldReader {
    private LargeListVector vector;
    private ValueVector data;
    private static final long OFFSET_WIDTH = 8L;
    private long currentOffset;
    private long maxOffset;

    public UnionLargeListReader(LargeListVector vector) {
        this.vector = vector;
        this.data = vector.getDataVector();
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.isNull(this.idx());
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        this.currentOffset = this.vector.getOffsetBuffer().getLong((long)index * 8L) - 1L;
        this.maxOffset = this.vector.getOffsetBuffer().getLong(((long)index + 1L) * 8L);
    }

    @Override
    public FieldReader reader() {
        return this.data.getReader();
    }

    @Override
    public Object readObject() {
        return this.vector.getObject(this.idx());
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LARGELIST;
    }

    @Override
    public void read(int index, UnionHolder holder) {
        this.setPosition(index);
        for (int i = -1; i < index; ++i) {
            this.next();
        }
        holder.reader = this.data.getReader();
        holder.isSet = this.data.getReader().isSet() ? 1 : 0;
    }

    @Override
    public int size() {
        int size = LargeMemoryUtil.checkedCastToInt(this.maxOffset - this.currentOffset - 1L);
        return size < 0 ? 0 : size;
    }

    @Override
    public boolean next() {
        if (this.currentOffset + 1L < this.maxOffset) {
            this.data.getReader().setPosition(LargeMemoryUtil.checkedCastToInt(++this.currentOffset));
            return true;
        }
        return false;
    }

    public void copyAsValue(UnionLargeListWriter writer) {
        ComplexCopier.copy(this, writer);
    }
}

