/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.compression;

import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compression.CompressionUtil;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.compression.NoCompressionCodec;
import java.util.EnumMap;
import java.util.ServiceLoader;

public interface CompressionCodec {
    public ArrowBuf compress(BufferAllocator var1, ArrowBuf var2);

    public ArrowBuf decompress(BufferAllocator var1, ArrowBuf var2);

    public CompressionUtil.CodecType getCodecType();

    public static interface Factory {
        public static final Factory INSTANCE = Factory.bestEffort();

        public CompressionCodec createCodec(CompressionUtil.CodecType var1);

        public CompressionCodec createCodec(CompressionUtil.CodecType var1, int var2);

        private static Factory bestEffort() {
            ServiceLoader<Factory> serviceLoader = ServiceLoader.load(Factory.class);
            final EnumMap<CompressionUtil.CodecType, Factory> factories = new EnumMap<CompressionUtil.CodecType, Factory>(CompressionUtil.CodecType.class);
            for (Factory factory : serviceLoader) {
                for (CompressionUtil.CodecType codecType : CompressionUtil.CodecType.values()) {
                    try {
                        factory.createCodec(codecType);
                        factories.putIfAbsent(codecType, factory);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            final NoCompressionCodec.Factory fallback = NoCompressionCodec.Factory.INSTANCE;
            return new Factory(){

                @Override
                public CompressionCodec createCodec(CompressionUtil.CodecType codecType) {
                    return factories.getOrDefault((Object)codecType, fallback).createCodec(codecType);
                }

                @Override
                public CompressionCodec createCodec(CompressionUtil.CodecType codecType, int compressionLevel) {
                    return factories.getOrDefault((Object)codecType, fallback).createCodec(codecType, compressionLevel);
                }
            };
        }
    }
}

