/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo;

import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectReader;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.dremio.jdbc.shaded.com.google.flatbuffers.FlatBufferBuilder;
import com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.KeyValue;
import com.dremio.jdbc.shaded.org.apache.arrow.util.Collections2;
import com.dremio.jdbc.shaded.org.apache.arrow.util.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.ReadChannel;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.WriteChannel;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.FBSerializables;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ipc.message.MessageSerializer;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Schema {
    static final String METADATA_KEY = "key";
    static final String METADATA_VALUE = "value";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
    private static final ObjectReader reader = mapper.readerFor(Schema.class);
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private final List<Field> fields;
    private final Map<String, String> metadata;

    public static Field findField(List<Field> fields, String name) {
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new IllegalArgumentException(String.format("field %s not found in %s", name, fields));
    }

    public static Schema fromJSON(String json) throws IOException {
        return (Schema)reader.readValue(Preconditions.checkNotNull(json));
    }

    @Deprecated
    public static Schema deserialize(ByteBuffer buffer) {
        return Schema.convertSchema(com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.getRootAsSchema(buffer));
    }

    public static Schema deserializeMessage(ByteBuffer buffer) {
        Schema schema;
        ByteBufferBackedInputStream stream = new ByteBufferBackedInputStream(buffer);
        ReadChannel channel = new ReadChannel(Channels.newChannel(stream));
        try {
            schema = MessageSerializer.deserializeSchema(channel);
        }
        catch (Throwable throwable) {
            try {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        channel.close();
        return schema;
    }

    public static Schema convertSchema(com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema schema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < schema.fieldsLength(); ++i) {
            fields.add(Field.convertField(schema.fields(i)));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < schema.customMetadataLength(); ++i) {
            KeyValue kv = schema.customMetadata(i);
            String key = kv.key();
            String value = kv.value();
            metadata.put(key == null ? "" : key, value == null ? "" : value);
        }
        return new Schema(true, Collections.unmodifiableList(fields), Collections.unmodifiableMap(metadata));
    }

    public Schema(Iterable<Field> fields) {
        this(fields, (Map<String, String>)null);
    }

    public Schema(Iterable<Field> fields, Map<String, String> metadata) {
        this(true, Collections2.toImmutableList(fields), metadata == null ? Collections.emptyMap() : Collections2.immutableMapCopy(metadata));
    }

    @JsonCreator
    private Schema(@JsonProperty(value="fields") Iterable<Field> fields, @JsonProperty(value="metadata") List<Map<String, String>> metadata) {
        this(fields, Schema.convertMetadata(metadata));
    }

    private Schema(boolean ignored, List<Field> fields, Map<String, String> metadata) {
        this.fields = fields;
        this.metadata = metadata;
    }

    static Map<String, String> convertMetadata(List<Map<String, String>> metadata) {
        return metadata == null ? null : metadata.stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, String>((String)e.get(METADATA_KEY), (String)e.get(METADATA_VALUE))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static List<Map<String, String>> convertMetadata(Map<String, String> metadata) {
        return metadata == null ? null : metadata.entrySet().stream().map(Schema::convertEntryToKeyValueMap).collect(Collectors.toList());
    }

    private static Map<String, String> convertEntryToKeyValueMap(Map.Entry<String, String> entry) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(METADATA_KEY, entry.getKey());
        map.put(METADATA_VALUE, entry.getValue());
        return Collections.unmodifiableMap(map);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @JsonIgnore
    public Map<String, String> getCustomMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    List<Map<String, String>> getCustomMetadataForJson() {
        return Schema.convertMetadata(this.getCustomMetadata());
    }

    public Field findField(String name) {
        return Schema.findField(this.getFields(), name);
    }

    public String toJson() {
        try {
            return writer.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getSchema(FlatBufferBuilder builder) {
        int[] fieldOffsets = new int[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            fieldOffsets[i] = this.fields.get(i).getField(builder);
        }
        int fieldsOffset = com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.createFieldsVector(builder, fieldOffsets);
        int metadataOffset = FBSerializables.writeKeyValues(builder, this.metadata);
        com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.startSchema(builder);
        com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.addEndianness(builder, LITTLE_ENDIAN ? (short)0 : 1);
        com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.addFields(builder, fieldsOffset);
        com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.addCustomMetadata(builder, metadataOffset);
        return com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema.endSchema(builder);
    }

    public byte[] serializeAsMessage() {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WriteChannel channel = new WriteChannel(Channels.newChannel(out));
        try {
            MessageSerializer.serialize(channel, this);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        channel.close();
        return byArray;
    }

    @Deprecated
    public byte[] toByteArray() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int schemaOffset = this.getSchema(builder);
        builder.finish(schemaOffset);
        ByteBuffer bb = builder.dataBuffer();
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        return bytes;
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.metadata);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Schema)) {
            return false;
        }
        return Objects.equals(this.fields, ((Schema)obj).fields) && Objects.equals(this.metadata, ((Schema)obj).metadata);
    }

    public String toString() {
        String meta = this.metadata.isEmpty() ? "" : "(metadata: " + this.metadata.toString() + ")";
        return "Schema<" + this.fields.stream().map(t2 -> t2.toString()).collect(Collectors.joining(", ")) + ">" + meta;
    }
}

