/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.calcite.avatica;

import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.proto.Common;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.remote.MetaDataOperation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;

public class QueryState {
    @JsonProperty(value="type")
    public final StateType type;
    @JsonProperty(value="sql")
    public final String sql;
    @JsonProperty(value="metaDataOperation")
    public final MetaDataOperation metaDataOperation;
    @JsonProperty(value="operationArgs")
    public final Object[] operationArgs;

    public QueryState(String sql) {
        this.sql = sql;
        this.type = StateType.SQL;
        this.metaDataOperation = null;
        this.operationArgs = null;
    }

    public QueryState(MetaDataOperation op, Object ... args) {
        this.metaDataOperation = Objects.requireNonNull(op);
        this.operationArgs = Arrays.copyOf(Objects.requireNonNull(args), args.length);
        this.type = StateType.METADATA;
        this.sql = null;
    }

    public QueryState(StateType type, String sql, MetaDataOperation op, Object ... args) {
        this.type = Objects.requireNonNull(type);
        switch (type) {
            case SQL: {
                this.sql = Objects.requireNonNull(sql);
                if (null != op) {
                    throw new IllegalArgumentException("Expected null MetaDataOperation, but got " + (Object)((Object)op));
                }
                this.metaDataOperation = null;
                if (null != args) {
                    throw new IllegalArgumentException("Expected null arguments, but got " + Arrays.toString(args));
                }
                this.operationArgs = null;
                break;
            }
            case METADATA: {
                this.metaDataOperation = Objects.requireNonNull(op);
                this.operationArgs = Objects.requireNonNull(args);
                if (null != sql) {
                    throw new IllegalArgumentException("Expected null SQl but got " + sql);
                }
                this.sql = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to handle StateType " + (Object)((Object)type));
            }
        }
    }

    public QueryState() {
        this.sql = null;
        this.metaDataOperation = null;
        this.type = null;
        this.operationArgs = null;
    }

    public StateType getType() {
        return this.type;
    }

    public String getSql() {
        assert (this.type == StateType.SQL);
        return this.sql;
    }

    public MetaDataOperation getMetaDataOperation() {
        assert (this.type == StateType.METADATA);
        return this.metaDataOperation;
    }

    public Object[] getOperationArgs() {
        assert (this.type == StateType.METADATA);
        return this.operationArgs;
    }

    public ResultSet invoke(Connection conn, Statement statement) throws SQLException {
        switch (this.type) {
            case SQL: {
                boolean ret = Objects.requireNonNull(statement).execute(this.sql);
                ResultSet results = statement.getResultSet();
                assert (ret || null == results);
                return results;
            }
            case METADATA: {
                DatabaseMetaData metadata = Objects.requireNonNull(conn).getMetaData();
                switch (this.metaDataOperation) {
                    case GET_ATTRIBUTES: {
                        this.verifyOpArgs(4);
                        return metadata.getAttributes((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String)this.operationArgs[3]);
                    }
                    case GET_BEST_ROW_IDENTIFIER: {
                        this.verifyOpArgs(5);
                        return metadata.getBestRowIdentifier((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (Integer)this.operationArgs[3], (Boolean)this.operationArgs[4]);
                    }
                    case GET_CATALOGS: {
                        this.verifyOpArgs(0);
                        return metadata.getCatalogs();
                    }
                    case GET_COLUMNS: {
                        this.verifyOpArgs(4);
                        return metadata.getColumns((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String)this.operationArgs[3]);
                    }
                    case GET_COLUMN_PRIVILEGES: {
                        this.verifyOpArgs(4);
                        return metadata.getColumnPrivileges((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String)this.operationArgs[3]);
                    }
                    case GET_CROSS_REFERENCE: {
                        this.verifyOpArgs(6);
                        return metadata.getCrossReference((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String)this.operationArgs[3], (String)this.operationArgs[4], (String)this.operationArgs[5]);
                    }
                    case GET_EXPORTED_KEYS: {
                        this.verifyOpArgs(3);
                        return metadata.getExportedKeys((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_FUNCTIONS: {
                        this.verifyOpArgs(3);
                        return metadata.getFunctions((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_FUNCTION_COLUMNS: {
                        this.verifyOpArgs(4);
                        return metadata.getFunctionColumns((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String)this.operationArgs[3]);
                    }
                    case GET_IMPORTED_KEYS: {
                        this.verifyOpArgs(3);
                        return metadata.getImportedKeys((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_INDEX_INFO: {
                        this.verifyOpArgs(5);
                        return metadata.getIndexInfo((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (Boolean)this.operationArgs[3], (Boolean)this.operationArgs[4]);
                    }
                    case GET_PRIMARY_KEYS: {
                        this.verifyOpArgs(3);
                        return metadata.getPrimaryKeys((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_PROCEDURES: {
                        this.verifyOpArgs(3);
                        return metadata.getProcedures((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_PROCEDURE_COLUMNS: {
                        this.verifyOpArgs(4);
                        return metadata.getProcedureColumns((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String)this.operationArgs[3]);
                    }
                    case GET_PSEUDO_COLUMNS: {
                        this.verifyOpArgs(4);
                        return metadata.getPseudoColumns((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String)this.operationArgs[3]);
                    }
                    case GET_SCHEMAS: {
                        this.verifyOpArgs(0);
                        return metadata.getSchemas();
                    }
                    case GET_SCHEMAS_WITH_ARGS: {
                        this.verifyOpArgs(2);
                        return metadata.getSchemas((String)this.operationArgs[0], (String)this.operationArgs[1]);
                    }
                    case GET_SUPER_TABLES: {
                        this.verifyOpArgs(3);
                        return metadata.getSuperTables((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_SUPER_TYPES: {
                        this.verifyOpArgs(3);
                        return metadata.getSuperTypes((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_TABLES: {
                        this.verifyOpArgs(4);
                        return metadata.getTables((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (String[])this.operationArgs[3]);
                    }
                    case GET_TABLE_PRIVILEGES: {
                        this.verifyOpArgs(3);
                        return metadata.getTablePrivileges((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                    case GET_TABLE_TYPES: {
                        this.verifyOpArgs(0);
                        return metadata.getTableTypes();
                    }
                    case GET_TYPE_INFO: {
                        this.verifyOpArgs(0);
                        return metadata.getTypeInfo();
                    }
                    case GET_UDTS: {
                        this.verifyOpArgs(4);
                        return metadata.getUDTs((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2], (int[])this.operationArgs[3]);
                    }
                    case GET_VERSION_COLUMNS: {
                        this.verifyOpArgs(3);
                        return metadata.getVersionColumns((String)this.operationArgs[0], (String)this.operationArgs[1], (String)this.operationArgs[2]);
                    }
                }
                throw new IllegalArgumentException("Unhandled Metadata operation: " + (Object)((Object)this.metaDataOperation));
            }
        }
        throw new IllegalArgumentException("Unable to process QueryState of type " + (Object)((Object)this.type));
    }

    private void verifyOpArgs(int expectedArgs) {
        if (expectedArgs != this.operationArgs.length) {
            throw new RuntimeException("Expected " + expectedArgs + " arguments, but got " + Arrays.toString(this.operationArgs));
        }
    }

    public Common.QueryState toProto() {
        Common.QueryState.Builder builder = Common.QueryState.newBuilder();
        switch (this.type) {
            case SQL: {
                builder.setType(Common.StateType.SQL);
                break;
            }
            case METADATA: {
                builder.setType(Common.StateType.METADATA);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.type));
            }
        }
        if (null != this.sql) {
            builder.setSql(this.sql).setHasSql(true);
        }
        if (null != this.metaDataOperation) {
            builder.setOp(this.metaDataOperation.toProto()).setHasOp(true);
        }
        if (null != this.operationArgs) {
            builder.setHasArgs(true);
            for (Object arg : this.operationArgs) {
                Common.MetaDataOperationArgument.Builder argBuilder = Common.MetaDataOperationArgument.newBuilder();
                if (null == arg) {
                    builder.addArgs(argBuilder.setType(Common.MetaDataOperationArgument.ArgumentType.NULL).build());
                    continue;
                }
                if (arg instanceof String) {
                    builder.addArgs(argBuilder.setType(Common.MetaDataOperationArgument.ArgumentType.STRING).setStringValue((String)arg).build());
                    continue;
                }
                if (arg instanceof Integer) {
                    builder.addArgs(argBuilder.setType(Common.MetaDataOperationArgument.ArgumentType.INT).setIntValue((Integer)arg).build());
                    continue;
                }
                if (arg instanceof Boolean) {
                    builder.addArgs(argBuilder.setType(Common.MetaDataOperationArgument.ArgumentType.BOOL).setBoolValue((Boolean)arg).build());
                    continue;
                }
                if (arg instanceof String[]) {
                    argBuilder.setType(Common.MetaDataOperationArgument.ArgumentType.REPEATED_STRING);
                    for (String strArg : (String[])arg) {
                        argBuilder.addStringArrayValues(strArg);
                    }
                    builder.addArgs(argBuilder.build());
                    continue;
                }
                if (arg instanceof int[]) {
                    argBuilder.setType(Common.MetaDataOperationArgument.ArgumentType.REPEATED_INT);
                    for (int intArg : (int[])arg) {
                        argBuilder.addIntArrayValues(intArg);
                    }
                    builder.addArgs(argBuilder.build());
                    continue;
                }
                throw new RuntimeException("Unexpected operation argument: " + arg.getClass());
            }
        } else {
            builder.setHasArgs(false);
        }
        return builder.build();
    }

    public static QueryState fromProto(Common.QueryState protoState) {
        StateType type = StateType.fromProto(protoState.getType());
        String sql = protoState.getHasSql() ? protoState.getSql() : null;
        MetaDataOperation op = protoState.getHasOp() ? MetaDataOperation.fromProto(protoState.getOp()) : null;
        Object[] opArgs = null;
        if (protoState.getHasArgs()) {
            opArgs = new Object[protoState.getArgsCount()];
            int i = 0;
            for (Common.MetaDataOperationArgument arg : protoState.getArgsList()) {
                switch (arg.getType()) {
                    case STRING: {
                        opArgs[i] = arg.getStringValue();
                        break;
                    }
                    case BOOL: {
                        opArgs[i] = arg.getBoolValue();
                        break;
                    }
                    case INT: {
                        opArgs[i] = arg.getIntValue();
                        break;
                    }
                    case REPEATED_STRING: {
                        opArgs[i] = arg.getStringArrayValuesList().toArray(new String[arg.getStringArrayValuesCount()]);
                        break;
                    }
                    case REPEATED_INT: {
                        int[] arr = new int[arg.getIntArrayValuesCount()];
                        int offset = 0;
                        for (Integer val : arg.getIntArrayValuesList()) {
                            arr[offset] = val;
                            ++offset;
                        }
                        opArgs[i] = arr;
                        break;
                    }
                    case NULL: {
                        opArgs[i] = null;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Could not interpret " + arg.getType());
                    }
                }
                ++i;
            }
        }
        return new QueryState(type, sql, op, opArgs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metaDataOperation, Arrays.hashCode(this.operationArgs), this.sql});
    }

    public boolean equals(Object o) {
        return o == this || o instanceof QueryState && this.metaDataOperation == ((QueryState)o).metaDataOperation && Arrays.deepEquals(this.operationArgs, ((QueryState)o).operationArgs) && Objects.equals(this.sql, ((QueryState)o).sql);
    }

    public static enum StateType {
        SQL,
        METADATA;


        public Common.StateType toProto() {
            switch (this) {
                case SQL: {
                    return Common.StateType.SQL;
                }
                case METADATA: {
                    return Common.StateType.METADATA;
                }
            }
            return Common.StateType.UNRECOGNIZED;
        }

        public static StateType fromProto(Common.StateType protoType) {
            switch (protoType) {
                case SQL: {
                    return SQL;
                }
                case METADATA: {
                    return METADATA;
                }
            }
            throw new IllegalArgumentException("Unhandled StateType " + protoType);
        }
    }
}

