/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.calcite.avatica.metrics;

import com.dremio.jdbc.shaded.org.apache.calcite.avatica.metrics.MetricsSystem;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.metrics.MetricsSystemConfiguration;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.metrics.MetricsSystemFactory;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.metrics.noop.NoopMetricsSystem;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public class MetricsSystemLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsSystemLoader.class);
    private static final MetricsSystemLoader INSTANCE = new MetricsSystemLoader();

    private MetricsSystemLoader() {
    }

    public static MetricsSystem load(MetricsSystemConfiguration<?> config) {
        return INSTANCE._load(Objects.requireNonNull(config));
    }

    MetricsSystem _load(MetricsSystemConfiguration<?> config) {
        List<MetricsSystemFactory> availableFactories = this.getFactories();
        if (1 == availableFactories.size()) {
            MetricsSystemFactory factory = availableFactories.get(0);
            LOG.info("Loaded MetricsSystem {}", (Object)factory.getClass());
            return factory.create(config);
        }
        if (availableFactories.isEmpty()) {
            LOG.info("No metrics implementation available on classpath. Using No-op implementation");
            return NoopMetricsSystem.getInstance();
        }
        StringBuilder sb = new StringBuilder();
        for (MetricsSystemFactory factory : availableFactories) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(factory.getClass());
        }
        LOG.warn("Found multiple MetricsSystemFactory implementations: {}. Using No-op implementation", (Object)sb);
        return NoopMetricsSystem.getInstance();
    }

    List<MetricsSystemFactory> getFactories() {
        ServiceLoader<MetricsSystemFactory> loader = ServiceLoader.load(MetricsSystemFactory.class);
        ArrayList<MetricsSystemFactory> availableFactories = new ArrayList<MetricsSystemFactory>();
        for (MetricsSystemFactory factory : loader) {
            availableFactories.add(factory);
        }
        return availableFactories;
    }
}

