/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.calcite.avatica.remote;

import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaUtils;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.remote.ProtobufService;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.remote.ProtobufTranslation;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.remote.Service;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;

public class RemoteProtobufService
extends ProtobufService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteProtobufService.class);
    private final AvaticaHttpClient client;
    private final ProtobufTranslation translation;

    public RemoteProtobufService(AvaticaHttpClient client, ProtobufTranslation translation) {
        this.client = client;
        this.translation = translation;
    }

    @Override
    public Service.Response _apply(Service.Request request) {
        Service.Response resp;
        byte[] response = null;
        try {
            response = this.client.send(this.translation.serializeRequest(request));
        }
        catch (IOException e) {
            LOG.debug("Failed to execute remote request: {}", (Object)request);
            throw new RuntimeException(e);
        }
        try {
            resp = this.translation.parseResponse(response);
        }
        catch (IOException e) {
            LOG.debug("Failed to deserialize reponse to {}. '{}'", (Object)request, (Object)AvaticaUtils.newStringUtf8(response));
            throw new RuntimeException(e);
        }
        if (resp instanceof Service.ErrorResponse) {
            throw ((Service.ErrorResponse)resp).toException();
        }
        return resp;
    }
}

