/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator;

import com.dremio.jdbc.shaded.org.apache.curator.RetryLoop;
import com.dremio.jdbc.shaded.org.apache.curator.RetryPolicy;
import com.dremio.jdbc.shaded.org.apache.curator.RetrySleeper;
import com.dremio.jdbc.shaded.org.apache.curator.drivers.EventTrace;
import com.dremio.jdbc.shaded.org.apache.curator.drivers.TracerDriver;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.atomic.AtomicReference;

class RetryLoopImpl
extends RetryLoop {
    private boolean isDone = false;
    private int retryCount = 0;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long startTimeMs = System.currentTimeMillis();
    private final RetryPolicy retryPolicy;
    private final AtomicReference<TracerDriver> tracer;
    private static final RetrySleeper sleeper = (time, unit) -> unit.sleep(time);

    RetryLoopImpl(RetryPolicy retryPolicy, AtomicReference<TracerDriver> tracer) {
        this.retryPolicy = retryPolicy;
        this.tracer = tracer;
    }

    static RetrySleeper getRetrySleeper() {
        return sleeper;
    }

    @Override
    public boolean shouldContinue() {
        return !this.isDone;
    }

    @Override
    public void markComplete() {
        this.isDone = true;
    }

    @Override
    public void takeException(Exception exception) throws Exception {
        boolean rethrow = true;
        if (this.retryPolicy.allowRetry(exception)) {
            if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                this.log.debug("Retry-able exception received", exception);
            }
            if (this.retryPolicy.allowRetry(this.retryCount++, System.currentTimeMillis() - this.startTimeMs, sleeper)) {
                new EventTrace("retries-allowed", this.tracer.get()).commit();
                if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                    this.log.debug("Retrying operation");
                }
                rethrow = false;
            } else {
                new EventTrace("retries-disallowed", this.tracer.get()).commit();
                if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                    this.log.debug("Retry policy not allowing retry");
                }
            }
        }
        if (rethrow) {
            throw exception;
        }
    }
}

