/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.imps;

import com.dremio.jdbc.shaded.org.apache.curator.drivers.OperationTrace;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.CuratorEventType;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.OperationAndData;
import com.dremio.jdbc.shaded.org.apache.zookeeper.AsyncCallback;

class BackgroundSyncImpl
implements BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private final Object context;

    BackgroundSyncImpl(CuratorFrameworkImpl client, Object context) {
        this.client = client;
        this.context = context;
    }

    @Override
    public CuratorEventType getBackgroundEventType() {
        return CuratorEventType.SYNC;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("BackgroundSyncImpl");
        final String data = operationAndData.getData();
        this.client.getZooKeeper().sync(data, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                trace.setReturnCode(rc).setRequestBytesLength(data).commit();
                CuratorEventImpl event = new CuratorEventImpl(BackgroundSyncImpl.this.client, CuratorEventType.SYNC, rc, path, null, ctx, null, null, null, null, null, null);
                BackgroundSyncImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.context);
    }
}

