/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.imps;

import com.dremio.jdbc.shaded.org.apache.curator.framework.CuratorFramework;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.BackgroundCallback;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.CuratorEvent;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.UnhandledErrorListener;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.Watching;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.base.Throwables;
import com.dremio.jdbc.shaded.org.apache.curator.utils.ThreadUtils;
import com.dremio.jdbc.shaded.org.apache.zookeeper.KeeperException;
import java.util.concurrent.Executor;

public class Backgrounding {
    private final boolean inBackground;
    private final Object context;
    private final BackgroundCallback callback;
    private final UnhandledErrorListener errorListener;

    Backgrounding(Object context) {
        this.inBackground = true;
        this.context = context;
        this.callback = null;
        this.errorListener = null;
    }

    Backgrounding(BackgroundCallback callback) {
        this.inBackground = true;
        this.context = null;
        this.callback = callback;
        this.errorListener = null;
    }

    Backgrounding(boolean inBackground) {
        this.inBackground = inBackground;
        this.context = null;
        this.callback = null;
        this.errorListener = null;
    }

    Backgrounding(BackgroundCallback callback, Object context) {
        this.inBackground = true;
        this.context = context;
        this.callback = callback;
        this.errorListener = null;
    }

    Backgrounding(CuratorFrameworkImpl client, BackgroundCallback callback, Object context, Executor executor) {
        this(Backgrounding.wrapCallback(client, callback, executor), context);
    }

    Backgrounding(CuratorFrameworkImpl client, BackgroundCallback callback, Executor executor) {
        this(Backgrounding.wrapCallback(client, callback, executor));
    }

    Backgrounding(Backgrounding rhs, UnhandledErrorListener errorListener) {
        if (rhs == null) {
            rhs = new Backgrounding();
        }
        this.inBackground = rhs.inBackground;
        this.context = rhs.context;
        this.callback = rhs.callback;
        this.errorListener = errorListener;
    }

    public Backgrounding(BackgroundCallback callback, UnhandledErrorListener errorListener) {
        this.callback = callback;
        this.errorListener = errorListener;
        this.inBackground = true;
        this.context = null;
    }

    Backgrounding() {
        this.inBackground = false;
        this.context = null;
        this.callback = null;
        this.errorListener = null;
    }

    boolean inBackground() {
        return this.inBackground;
    }

    Object getContext() {
        return this.context;
    }

    BackgroundCallback getCallback() {
        return this.callback;
    }

    void checkError(Throwable e, Watching watching) throws Exception {
        if (e != null) {
            if (this.errorListener != null) {
                this.errorListener.unhandledError("n/a", e);
            } else {
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                Throwables.propagate(e);
            }
        }
    }

    private static BackgroundCallback wrapCallback(final CuratorFrameworkImpl client, final BackgroundCallback callback, final Executor executor) {
        return new BackgroundCallback(){

            @Override
            public void processResult(CuratorFramework dummy, final CuratorEvent event) throws Exception {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.processResult(client, event);
                        }
                        catch (Exception e) {
                            ThreadUtils.checkInterrupted(e);
                            if (e instanceof KeeperException) {
                                client.validateConnection(client.codeToState(((KeeperException)e).code()));
                            }
                            client.logError("Background operation result handling threw exception", e);
                        }
                    }
                });
            }
        };
    }
}

