/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.imps;

import com.dremio.jdbc.shaded.org.apache.curator.framework.api.CuratorEvent;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.CuratorEventType;
import com.dremio.jdbc.shaded.org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.NamespaceWatchedEvent;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import com.dremio.jdbc.shaded.org.apache.zookeeper.WatchedEvent;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.ACL;
import com.dremio.jdbc.shaded.org.apache.zookeeper.data.Stat;
import java.util.Arrays;
import java.util.List;

class CuratorEventImpl
implements CuratorEvent {
    private final CuratorEventType type;
    private final int resultCode;
    private final String path;
    private final String name;
    private final List<String> children;
    private final Object context;
    private final Stat stat;
    private final byte[] data;
    private final WatchedEvent watchedEvent;
    private final List<ACL> aclList;
    private final List<CuratorTransactionResult> opResults;

    @Override
    public CuratorEventType getType() {
        return this.type;
    }

    @Override
    public int getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public Stat getStat() {
        return this.stat;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getChildren() {
        return this.children;
    }

    @Override
    public WatchedEvent getWatchedEvent() {
        return this.watchedEvent;
    }

    @Override
    public List<ACL> getACLList() {
        return this.aclList;
    }

    @Override
    public List<CuratorTransactionResult> getOpResults() {
        return this.opResults;
    }

    public String toString() {
        return "CuratorEventImpl{type=" + (Object)((Object)this.type) + ", resultCode=" + this.resultCode + ", path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", children=" + this.children + ", context=" + this.context + ", stat=" + this.stat + ", data=" + Arrays.toString(this.data) + ", watchedEvent=" + this.watchedEvent + ", aclList=" + this.aclList + ", opResults=" + this.opResults + '}';
    }

    CuratorEventImpl(CuratorFrameworkImpl client, CuratorEventType type, int resultCode, String path, String name, Object context, Stat stat, byte[] data, List<String> children, WatchedEvent watchedEvent, List<ACL> aclList, List<CuratorTransactionResult> opResults) {
        this.type = type;
        this.resultCode = resultCode;
        this.opResults = opResults != null ? ImmutableList.copyOf(opResults) : null;
        this.path = client.unfixForNamespace(path);
        this.name = client.unfixForNamespace(name);
        this.context = context;
        this.stat = stat;
        this.data = data;
        this.children = children;
        this.watchedEvent = watchedEvent != null ? new NamespaceWatchedEvent(client, watchedEvent) : null;
        this.aclList = aclList != null ? ImmutableList.copyOf(aclList) : null;
    }
}

