/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.imps;

import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.NamespaceFacade;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.cache.CacheBuilder;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.cache.CacheLoader;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class NamespaceFacadeCache {
    private final CuratorFrameworkImpl client;
    private final AtomicReference<NamespaceFacade> nullNamespace;
    private final CacheLoader<String, NamespaceFacade> loader = new CacheLoader<String, NamespaceFacade>(){

        @Override
        public NamespaceFacade load(String namespace) throws Exception {
            return new NamespaceFacade(NamespaceFacadeCache.this.client, namespace);
        }
    };
    private final LoadingCache<String, NamespaceFacade> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(this.loader);

    NamespaceFacadeCache(CuratorFrameworkImpl client) {
        this.client = client;
        this.nullNamespace = new AtomicReference<Object>(null);
    }

    private NamespaceFacade getNullNamespace() {
        NamespaceFacade facade = this.nullNamespace.get();
        if (facade != null) {
            return facade;
        }
        facade = new NamespaceFacade(this.client, null);
        if (!this.nullNamespace.compareAndSet(null, facade)) {
            facade = this.nullNamespace.get();
        }
        return facade;
    }

    NamespaceFacade get(String namespace) {
        try {
            if (namespace == null) {
                return this.getNullNamespace();
            }
            return this.cache.get(namespace);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

