/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.org.apache.curator.framework.imps;

import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.NamespaceWatcher;
import com.dremio.jdbc.shaded.org.apache.curator.framework.imps.RemoveWatchesBuilderImpl;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.collect.Lists;
import com.dremio.jdbc.shaded.org.apache.curator.shaded.com.google.common.collect.Sets;
import com.dremio.jdbc.shaded.org.apache.zookeeper.Watcher;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Set;

public class WatcherRemovalManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkImpl client;
    private final Set<NamespaceWatcher> entries = Sets.newConcurrentHashSet();

    WatcherRemovalManager(CuratorFrameworkImpl client) {
        this.client = client;
    }

    void add(NamespaceWatcher watcher) {
        watcher = Preconditions.checkNotNull(watcher, "watcher cannot be null");
        this.entries.add(watcher);
    }

    @VisibleForTesting
    Set<? extends Watcher> getEntries() {
        return Sets.newHashSet(this.entries);
    }

    void removeWatchers() {
        ArrayList<NamespaceWatcher> localEntries = Lists.newArrayList(this.entries);
        while (localEntries.size() > 0) {
            NamespaceWatcher watcher = (NamespaceWatcher)localEntries.remove(0);
            if (!this.entries.remove(watcher)) continue;
            try {
                this.log.debug("Removing watcher for path: " + watcher.getUnfixedPath());
                RemoveWatchesBuilderImpl builder = new RemoveWatchesBuilderImpl(this.client);
                builder.internalRemoval(watcher, watcher.getUnfixedPath());
            }
            catch (Exception e) {
                this.log.error("Could not remove watcher for path: " + watcher.getUnfixedPath());
            }
        }
    }

    void noteTriggeredWatcher(NamespaceWatcher watcher) {
        this.entries.remove(watcher);
    }
}

